/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.api.iitem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.iitem.IPorch;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.PotionInit;
import sweetmagic.util.WorldHelper;

public interface IRangeTool {
    public static final List<BlockEntityType<?>> tileList = Arrays.asList(BlockEntityType.f_58920_, BlockEntityType.f_58925_);

    public int getRange();

    default public boolean isDepth() {
        return false;
    }

    default public void rangeBreake(ItemStack stack, Level world, BlockPos pos, LivingEntity living, RayTracePointer ray) {
        Item item;
        int rangeZ;
        BlockHitResult result;
        Player player;
        block24: {
            block23: {
                if (world.m_5776_() || !(living instanceof Player)) break block23;
                player = (Player)living;
                if (!living.m_21023_(PotionInit.non_destructive)) break block24;
            }
            return;
        }
        HitResult mop = ray.rayTrace(world, player, ClipContext.Fluid.NONE);
        if (!(mop instanceof BlockHitResult) || (result = (BlockHitResult)mop).m_6662_() == HitResult.Type.MISS || !pos.equals((Object)result.m_82425_())) {
            return;
        }
        Direction face = result.m_82434_();
        int area = this.getRange();
        int xa = 0;
        int ya = 0;
        int za = 0;
        int xb = 0;
        int yb = 0;
        int zb = 0;
        int rangeY = rangeZ = area++;
        int rangeX = rangeZ;
        switch (face) {
            case UP: {
                ya = this.isDepth() ? -area : 0;
                rangeY = 0;
                break;
            }
            case DOWN: {
                yb = this.isDepth() ? area : 0;
                rangeY = 0;
                break;
            }
            case NORTH: {
                zb = this.isDepth() ? area : 0;
                rangeZ = 0;
                break;
            }
            case SOUTH: {
                za = this.isDepth() ? -area : 0;
                rangeZ = 0;
                break;
            }
            case EAST: {
                xb = this.isDepth() ? -area : 0;
                rangeX = 0;
                break;
            }
            case WEST: {
                xa = this.isDepth() ? area : 0;
                rangeX = 0;
            }
        }
        Iterable<BlockPos> pList = WorldHelper.getRangePos(pos, -rangeX + xa, -rangeY + ya, -rangeZ + za, rangeX + xb, rangeY + yb, rangeZ + zb);
        ArrayList dropList = new ArrayList();
        int sumXP = 0;
        int fortune = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)stack);
        int silkTouch = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)stack);
        ItemStack leg = player.m_6844_(EquipmentSlot.LEGS);
        if (!leg.m_41619_() && (item = leg.m_41720_()) instanceof IPorch) {
            IPorch porch = (IPorch)item;
            silkTouch = porch.hasAcceIsActive(leg, ItemInit.earth_ruby_ring) ? 1 : 0;
        }
        for (BlockPos p : pList) {
            BlockState state = world.m_8055_(p);
            if (!this.isAllBlock() && !stack.m_41735_(state)) continue;
            Block block = state.m_60734_();
            BlockEntity tile = world.m_7702_(p);
            if (tile != null && !tileList.contains(tile.m_58903_()) && tile != null) continue;
            if (silkTouch <= 0) {
                if (world instanceof ServerLevel) {
                    server = (ServerLevel)world;
                    dropList.addAll(Block.m_49874_((BlockState)state, (ServerLevel)server, (BlockPos)p, (BlockEntity)tile, (Entity)living, (ItemStack)stack));
                }
                if (block instanceof DropExperienceBlock) {
                    DropExperienceBlock ex = (DropExperienceBlock)block;
                    sumXP += ex.getExpDrop(state, (LevelReader)world, world.m_213780_(), pos, fortune, silkTouch);
                }
            } else if (world instanceof ServerLevel) {
                server = (ServerLevel)world;
                dropList.addAll(block.m_7381_(state, this.getLoot(server, pos)));
            }
            if (state.m_60713_(BlockInit.magicbarrier)) {
                block.m_5707_(world, pos, state, player);
            }
            world.m_7471_(p, false);
            living.m_146850_(GameEvent.f_157794_);
        }
        if (!dropList.isEmpty()) {
            BlockPos pPos = living.m_20183_();
            dropList.forEach(s -> world.m_7967_((Entity)new ItemEntity(world, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), s)));
            if (sumXP > 0) {
                world.m_7967_((Entity)new ExperienceOrb(world, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), sumXP));
            }
        }
    }

    default public LootContext.Builder getLoot(ServerLevel world, BlockPos pos) {
        ItemStack tool = new ItemStack((ItemLike)ItemInit.alt_pick);
        tool.m_41663_(Enchantments.f_44985_, 1);
        return new LootContext.Builder(world).m_230911_(world.m_213780_()).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78972_(LootContextParams.f_81463_, (Object)tool).m_78984_(LootContextParams.f_81462_, (Object)world.m_7702_(pos));
    }

    default public boolean isAllBlock() {
        return false;
    }

    @FunctionalInterface
    public static interface RayTracePointer {
        public HitResult rayTrace(Level var1, Player var2, ClipContext.Fluid var3);
    }
}

