/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.api.util;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public interface ISMTip {
    public static final ChatFormatting RED = ChatFormatting.RED;
    public static final ChatFormatting GREEN = ChatFormatting.GREEN;
    public static final ChatFormatting GOLD = ChatFormatting.GOLD;
    public static final ChatFormatting WHITE = ChatFormatting.WHITE;
    public static final ChatFormatting BLACK = ChatFormatting.BLACK;

    default public MutableComponent getTipArray(Object ... objArray) {
        MutableComponent com = null;
        for (Object obj : objArray) {
            MutableComponent tip;
            if (obj instanceof Component) {
                Component co = (Component)obj;
                com = com == null ? (MutableComponent)obj : com.m_7220_(co);
                continue;
            }
            if (obj instanceof String) {
                String st = (String)obj;
                tip = this.getLabel(st);
                com = com == null ? tip : com.m_7220_((Component)tip);
                continue;
            }
            if (obj instanceof ChatFormatting) {
                ChatFormatting chat = (ChatFormatting)obj;
                if (com != null) {
                    com.m_130940_(chat);
                    continue;
                }
            }
            tip = this.getLabel("" + obj);
            com = com == null ? tip : com.m_7220_((Component)tip);
        }
        return com;
    }

    default public MutableComponent getLabel(Object tip, ChatFormatting color) {
        return this.getLabel(tip).m_130940_(color);
    }

    default public MutableComponent getLabel(Object tip) {
        return Component.m_237113_((String)("" + tip));
    }

    default public MutableComponent getTip(String tip) {
        return Component.m_237115_((String)tip);
    }

    default public MutableComponent getText(String tip) {
        return this.getTip("tip.sweetmagic." + tip);
    }

    default public MutableComponent getText(String tip, Object ... text) {
        return Component.m_237110_((String)("tip.sweetmagic." + tip), (Object[])text);
    }

    default public MutableComponent getEffectTip(String tip) {
        return this.getTip("effect.sweetmagic." + tip);
    }

    default public MutableComponent getEntityTip(String tip) {
        return this.getTip("entity.sweetmagic." + tip);
    }

    default public MutableComponent getMCTip(String tip) {
        return this.getTip("effect.minecraft." + tip);
    }

    default public MutableComponent getEnchaTip(int level) {
        return this.getTip("enchantment.level." + level);
    }

    default public void getShiftTip(List<Component> tooltip) {
        tooltip.add((Component)this.getText("shift").m_130940_(RED));
    }

    default public MutableComponent enumString(String name) {
        return this.getText(name.toLowerCase());
    }

    default public MutableComponent empty() {
        return Component.m_237113_((String)" ");
    }

    default public MutableComponent tierTip(int tier) {
        return this.getTipArray(this.getText("tier"), ": ", this.getLabel(tier, WHITE), GREEN);
    }

    default public String format(int num) {
        return String.format("%,d", num);
    }

    default public String format(float num) {
        return String.format("%.1f", Float.valueOf(num));
    }

    default public MutableComponent formatParZero(float num) {
        return this.getLabel(String.format("%.0f%%", Float.valueOf(num)));
    }

    default public MutableComponent formatPar(float num) {
        return this.getLabel(String.format("%.1f%%", Float.valueOf(num)));
    }

    default public MutableComponent formatPar(float num, ChatFormatting color) {
        return this.getLabel(String.format("%.1f%%", Float.valueOf(num)), color);
    }
}

