/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.block.magic.MagicianLectern;
import sweetmagic.init.tile.sm.TileAbstractMagicianLectern;

public class BlockBreakEvent {
    private static final List<Player> playerList = new ArrayList<Player>();
    private static final List<Player> playerPlaceList = new ArrayList<Player>();
    private static final List<Direction> ALL_FACE = Arrays.asList(Direction.UP, Direction.DOWN, Direction.NORTH, Direction.EAST, Direction.WEST, Direction.SOUTH);
    private static final List<Material> materialList = Arrays.asList(Material.f_76278_, Material.f_76279_);
    private static final List<Material> requiredList = Arrays.asList(Material.f_76275_);
    private static final List<Block> blockList = Arrays.asList(Blocks.f_50183_, BlockInit.smspawner, BlockInit.crystal_pedal);

    @SubscribeEvent
    public static void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        LevelAccessor world = event.getLevel();
        if (player == null || world.m_5776_()) {
            return;
        }
        BlockState state = event.getState();
        Block block = state.m_60734_();
        if (!player.m_7500_() && player.m_21023_(PotionInit.non_destructive) && !blockList.contains(block)) {
            float time = block.m_155943_();
            Material mate = state.m_60767_();
            if (time >= 1.0f && materialList.contains(mate) || requiredList.contains(mate)) {
                if (!player.m_9236_().m_5776_() && !playerList.contains(player)) {
                    player.m_213846_((Component)Component.m_237115_((String)"tip.sweetmagic.non_destructive").m_130940_(ChatFormatting.GREEN));
                    playerList.add(player);
                }
                event.setCanceled(true);
                return;
            }
        } else if (player.m_21205_().m_150930_(ItemInit.startlight_wand)) {
            event.setCanceled(true);
            return;
        }
        if (!(block instanceof MagicianLectern)) {
            return;
        }
        BlockPos pos = event.getPos();
        TileAbstractMagicianLectern tile = (TileAbstractMagicianLectern)world.m_7702_(pos);
        if (tile.summonType.is(TileAbstractMagicianLectern.SummonType.START) || tile.summonType.is(TileAbstractMagicianLectern.SummonType.END)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onBlockPlaceEvent(BlockEvent.EntityPlaceEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player) || (player = (Player)entity).m_7500_() || !player.m_21023_(PotionInit.non_destructive)) {
            return;
        }
        if (BlockBreakEvent.checkSide(player.m_9236_(), event.getPos())) {
            return;
        }
        if (!player.m_9236_().m_5776_() && !playerPlaceList.contains(player)) {
            player.m_213846_((Component)Component.m_237115_((String)"tip.sweetmagic.non_destructive_place").m_130940_(ChatFormatting.GREEN));
            playerPlaceList.add(player);
        }
        event.setCanceled(true);
    }

    public static boolean checkSide(Level world, BlockPos pos) {
        for (Direction face : ALL_FACE) {
            if (!world.m_8055_(pos.m_121945_(face)).m_60713_(BlockInit.magicbarrier_lock)) continue;
            return false;
        }
        return true;
    }
}

