/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.event.SMUtilEvent;
import sweetmagic.init.item.sm.DungeonCompas;

@OnlyIn(value=Dist.CLIENT)
public class CompasRenderEvent
extends SMUtilEvent {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_misc.png");

    @SubscribeEvent
    public static void onWandRenderEvent(RenderGuiOverlayEvent.Post event) {
        if (!event.getOverlay().id().equals((Object)VanillaGuiOverlay.HOTBAR.id())) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player.m_5833_()) {
            return;
        }
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (!(item instanceof DungeonCompas)) {
            return;
        }
        DungeonCompas compas = (DungeonCompas)item;
        CompoundTag tags = stack.m_41784_();
        PoseStack pose = event.getPoseStack();
        Matrix4f mat = pose.m_85850_().m_85861_();
        int height = event.getWindow().m_85446_() + 60;
        int weight = event.getWindow().m_85445_() + 8;
        CompasRenderEvent.renderStart(TEX);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.39215687f);
        CompasRenderEvent.drawTextured(mat, weight - 80, height - 190, 192, 192, 64, 64);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        CompasRenderEvent.drawTextured(mat, weight - 80, height - 190, 0, 192, 64, 64);
        Font font = mc.f_91062_;
        int posX = weight - 80;
        int posZ = height - 120;
        if (tags.m_128471_("isSearch")) {
            CompasRenderEvent.renderFont(pose, font, CompasRenderEvent.getText("is_serach"), posX + 60, posZ);
            return;
        }
        if (tags.m_128471_("notFound")) {
            CompasRenderEvent.renderFont(pose, font, CompasRenderEvent.getTip("structure.sweetmagic." + compas.getDungeonName(stack)), posX + 60, posZ + 12);
            CompasRenderEvent.renderFont(pose, font, CompasRenderEvent.getText("not_found"), posX + 60, posZ);
            return;
        }
        int pX = tags.m_128451_("X");
        int pY = player.m_20183_().m_123342_();
        int pZ = tags.m_128451_("Z");
        BlockPos pos = new BlockPos(pX, pY, pZ);
        if (tags.m_128471_("foundStructure")) {
            float angle = compas.getRotCompas((Entity)player, pos);
            float addX = (float)Math.sin(angle * 6.15f) * 21.0f;
            float addY = -((float)Math.cos(angle * 6.15f)) * 21.0f;
            CompasRenderEvent.drawTextured(mat, weight - 52 + (int)addX, height - 162 + (int)addY, 64, 200, 9, 9);
        }
        double dis = Math.abs(player.f_19854_ - (double)pos.m_123341_()) + Math.abs(player.f_19856_ - (double)pos.m_123343_()) - 0.5;
        boolean foundStructure = tags.m_128471_("foundStructure");
        posZ = !foundStructure ? posZ - 12 : posZ;
        CompasRenderEvent.renderFont(pose, font, CompasRenderEvent.getTip("structure.sweetmagic." + compas.getDungeonName(stack)), posX + 60, posZ + 12);
        if (foundStructure) {
            CompasRenderEvent.renderFont(pose, font, CompasRenderEvent.getLabel(pX + ", " + pZ), posX + 60, posZ);
            CompasRenderEvent.renderFont(pose, font, CompasRenderEvent.getLabel(String.format("%,.1f", dis) + " Block"), posX + 60, posZ + 24);
        } else {
            CompasRenderEvent.renderFont(pose, font, CompasRenderEvent.getText("compas_click").m_130940_(RED), posX + 60, posZ + 24);
        }
    }

    public static void renderFont(PoseStack pose, Font font, MutableComponent tip, int x, int z) {
        int nameSize = font.m_92895_(tip.getString());
        font.m_92763_(pose, (Component)tip, (float)(x - nameSize), (float)z, 0xFFFFFF);
    }
}

