/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.event;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import sweetmagic.config.SMConfig;
import sweetmagic.init.capability.icap.IWorldData;

public class EntitiySpawnEvent {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        BlockPos pos;
        if (event.getResult() == Event.Result.ALLOW || event.isSpawner() || event.isCanceled()) {
            return;
        }
        Mob mob = event.getEntity();
        if (mob instanceof Phantom && (Boolean)SMConfig.spawnPhantom.get() == false || mob instanceof Drowned && (Boolean)SMConfig.spawnDrowned.get() == false || mob instanceof WanderingTrader && !((Boolean)SMConfig.spawnTrader.get()).booleanValue()) {
            event.setResult(Event.Result.DENY);
        }
        if (!(mob instanceof Enemy) && !(mob instanceof Bat)) {
            return;
        }
        Level world = mob.m_9236_();
        if (IWorldData.isPosInRange(world, pos = new BlockPos(event.getX(), event.getY(), event.getZ()))) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityCheckSpecialSpawn(LivingSpawnEvent.SpecialSpawn event) {
        if (((Boolean)SMConfig.spawnTrader.get()).booleanValue()) {
            return;
        }
        Mob mob = event.getEntity();
        if (!(mob instanceof WanderingTrader)) {
            return;
        }
        event.setResult(Event.Result.DENY);
        mob.m_21153_(0.0f);
    }
}

