/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.event;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import sweetmagic.api.iblock.ITileMF;
import sweetmagic.api.iitem.IRangeTool;
import sweetmagic.api.iitem.IWand;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.item.sm.SMHoe;
import sweetmagic.util.WorldHelper;

@Mod.EventBusSubscriber(modid="sweetmagic", value={Dist.CLIENT})
public class HasItemEvent {
    private static int tickTime = 0;
    private static int renderTime = 0;
    public static boolean hasThisItem = false;
    private static List<Item> itemList = new ArrayList<Item>();

    @SubscribeEvent
    public static void renderfov(ComputeFovModifierEvent event) {
        if (++renderTime % 10 == 0) {
            renderTime = 0;
            HasItemEvent.onMFMFlow(event);
        }
        if (++tickTime % 16 != 0) {
            return;
        }
        tickTime = 0;
        Player player = event.getPlayer();
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_()) {
            hasThisItem = false;
            return;
        }
        Item item = stack.m_41720_();
        ItemStack wandStack = IWand.getWand(player);
        if (!wandStack.m_41619_()) {
            WandInfo info = new WandInfo(wandStack);
            item = info.getWand().getSlotItem(player, info).m_41720_();
        }
        if (itemList.isEmpty()) {
            itemList = Arrays.asList(ItemInit.magic_light, ItemInit.magic_holy_light, ItemInit.magic_illuminate, ItemInit.magic_shining_flare, Item.m_41439_((Block)BlockInit.magiclight));
        }
        Level world = player.m_9236_();
        hasThisItem = itemList.contains(item);
        if (hasThisItem && world.m_5776_()) {
            HasItemEvent.renderEffect(world, player);
        }
    }

    public static void onMFMFlow(ComputeFovModifierEvent event) {
        Player player = event.getPlayer();
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_() || stack.m_41720_() != ItemInit.mf_stuff || !player.m_9236_().m_5776_()) {
            return;
        }
        int area = 16;
        Level world = player.m_9236_();
        BlockPos pPos = player.m_20097_();
        SimpleParticleType par = ParticleInit.MF;
        Iterable<BlockPos> pList = WorldHelper.getRangePos(pPos, area);
        for (BlockPos pos : pList) {
            ITileMF tile;
            BlockEntity bEntity = world.m_7702_(pos);
            if (bEntity == null || !(bEntity instanceof ITileMF) || (tile = (ITileMF)bEntity).getPosList().isEmpty()) continue;
            HasItemEvent.renderMFFlow(world, pos, tile.getPosList(), (ParticleOptions)par);
        }
    }

    public static void renderEffect(Level world, Player player) {
        int area = 12;
        BlockPos pPos = player.m_20097_();
        SimpleParticleType par = ParticleInit.MAGICLIGHT;
        Iterable<BlockPos> posList = WorldHelper.getRangePos(pPos, area);
        for (BlockPos pos : posList) {
            if (world.m_8055_(pos).m_60734_() != BlockInit.magiclight) continue;
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.6;
            double z = (double)pos.m_123343_() + 0.5;
            world.m_7106_((ParticleOptions)par, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static void renderMFFlow(Level world, BlockPos basePos, Set<BlockPos> posList, ParticleOptions par) {
        float speed = 0.0265f;
        for (BlockPos pos : posList) {
            if (!(world.m_7702_(pos) instanceof ITileMF)) continue;
            float x = (float)pos.m_123341_() + 0.5f;
            float y = (float)pos.m_123342_() + 0.5f;
            float z = (float)pos.m_123343_() + 0.5f;
            float xSpeed = (float)(basePos.m_123341_() - pos.m_123341_()) * speed;
            float ySpeed = (float)(basePos.m_123342_() - pos.m_123342_()) * speed;
            float zSpeed = (float)(basePos.m_123343_() - pos.m_123343_()) * speed;
            world.m_7106_(par, (double)x, (double)y, (double)z, (double)xSpeed, (double)ySpeed, (double)zSpeed);
        }
    }

    @SubscribeEvent
    public static void renderBreakeRange(RenderHighlightEvent.Block event) {
        int rangeZ;
        IRangeTool tool;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ItemStack stack = player.m_21205_();
        if (player.m_6144_() || stack.m_41619_()) {
            return;
        }
        Item item = stack.m_41720_();
        if (item instanceof SMHoe) {
            SMHoe hoe = (SMHoe)item;
            HasItemEvent.renderRangeHoe(event, hoe);
        }
        if (!((item = stack.m_41720_()) instanceof IRangeTool) || (tool = (IRangeTool)item).getRange() == 0) {
            return;
        }
        ClientLevel world = mc.f_91073_;
        Camera camera = mc.f_91063_.m_109153_();
        double posX = camera.m_90583_().f_82479_;
        double posY = camera.m_90583_().f_82480_;
        double posZ = camera.m_90583_().f_82481_;
        Vec3 vec = event.getTarget().m_82450_();
        BlockPos pos = new BlockPos(vec.f_82479_, vec.f_82480_, vec.f_82481_);
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        VertexConsumer con = buffer.m_6299_(RenderType.m_173247_());
        int area = 1;
        int xa = 0;
        int ya = 0;
        int za = 0;
        int xb = 0;
        int yb = 0;
        int zb = 0;
        int rangeY = rangeZ = area++;
        int rangeX = rangeZ;
        switch (event.getTarget().m_82434_()) {
            case UP: {
                ya = tool.isDepth() ? -area : 0;
                rangeY = 0;
                pos = pos.m_7495_();
                break;
            }
            case DOWN: {
                yb = tool.isDepth() ? area : 0;
                rangeY = 0;
                break;
            }
            case NORTH: {
                zb = tool.isDepth() ? area : 0;
                xb = -1;
                xa = -1;
                yb = 0;
                ya = 0;
                za = 0;
                rangeZ = 0;
                break;
            }
            case SOUTH: {
                za = tool.isDepth() ? -area : 0;
                rangeZ = 0;
                pos = pos.m_122012_();
                break;
            }
            case EAST: {
                xb = tool.isDepth() ? -area : 0;
                ya = 0;
                yb = 0;
                xa = 0;
                rangeX = 0;
                zb = -1;
                za = -1;
                pos = pos.m_122024_();
                break;
            }
            case WEST: {
                xa = tool.isDepth() ? area : 0;
                ya = 0;
                yb = 0;
                zb = 0;
                rangeX = 0;
                zb = -1;
            }
        }
        Iterable<BlockPos> pList = WorldHelper.getRangePos(pos, -rangeX + xa, -rangeY + ya, -rangeZ + za, rangeX + xb, rangeY + yb, rangeZ + zb);
        for (BlockPos p : pList) {
            if (!tool.isAllBlock() && !stack.m_41735_(world.m_8055_(p)) || world.m_7702_(p) != null) continue;
            VoxelShape voxel = world.m_8055_(p).m_60812_((BlockGetter)world, p);
            HasItemEvent.drawShape(event.getPoseStack(), con, voxel, -posX + (double)p.m_123341_(), -posY + (double)p.m_123342_(), -posZ + (double)p.m_123343_());
        }
    }

    public static void renderRangeHoe(RenderHighlightEvent.Block event, SMHoe hoe) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel world = mc.f_91073_;
        Camera camera = mc.f_91063_.m_109153_();
        double posX = camera.m_90583_().f_82479_;
        double posY = camera.m_90583_().f_82480_;
        double posZ = camera.m_90583_().f_82481_;
        Vec3 vec = event.getTarget().m_82450_();
        BlockPos pos = new BlockPos(vec.f_82479_, vec.f_82480_, vec.f_82481_);
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        VertexConsumer con = buffer.m_6299_(RenderType.m_173247_());
        if (event.getTarget().m_82434_() == Direction.UP) {
            pos = pos.m_7495_();
        }
        Iterable<BlockPos> pList = WorldHelper.getRangePos(pos, -1.0, 0.0, -1.0, 1.0, 0.0, 1.0);
        for (BlockPos p : pList) {
            if (hoe.getHoeState((Level)world, p) == null) continue;
            VoxelShape voxel = world.m_8055_(p).m_60812_((BlockGetter)world, p);
            HasItemEvent.drawShape(event.getPoseStack(), con, voxel, -posX + (double)p.m_123341_(), -posY + (double)p.m_123342_(), -posZ + (double)p.m_123343_());
        }
    }

    private static void drawShape(PoseStack pose, VertexConsumer con, VoxelShape voxel, double x, double y, double z) {
        Matrix4f mat4 = pose.m_85850_().m_85861_();
        Matrix3f mat3 = pose.m_85850_().m_85864_();
        voxel.m_83224_((x1, y1, z1, x2, y2, z2) -> {
            con.m_85982_(mat4, (float)(x1 + x), (float)(y1 + y), (float)(z1 + z)).m_85950_(0.13f, 0.13f, 0.13f, 1.0f).m_85977_(mat3, 3.0f, 3.0f, 3.0f).m_5752_();
            con.m_85982_(mat4, (float)(x2 + x), (float)(y2 + y), (float)(z2 + z)).m_85950_(0.13f, 0.13f, 0.13f, 1.0f).m_85977_(mat3, 3.0f, 3.0f, 3.0f).m_5752_();
        });
    }
}

