/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.event;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import sweetmagic.api.iitem.IHarness;
import sweetmagic.init.EnchantInit;
import sweetmagic.init.PotionInit;
import sweetmagic.util.PlayerHelper;

public class PotionEvent {
    @SubscribeEvent
    public static void potionAddEvent(MobEffectEvent.Added event) {
        LivingEntity entity = event.getEntity();
        MobEffectInstance instance = event.getEffectInstance();
        MobEffectCategory cate = instance.m_19544_().m_19483_();
        if (!entity.m_21023_(PotionInit.debuff_extension) || instance.equals((Object)PotionInit.debuff_extension) || !cate.equals((Object)PotionInit.DEBUFF)) {
            return;
        }
        int level = entity.m_21124_(PotionInit.debuff_extension).m_19564_() + 1;
        float rate = 1.0f + (float)level * 0.25f;
        MobEffectInstance newInstance = new MobEffectInstance(instance.m_19544_(), (int)((float)instance.m_19557_() * rate), instance.m_19564_());
        instance.m_19558_(newInstance);
    }

    @SubscribeEvent
    public static void potionRemoveEvent(MobEffectEvent.Remove event) {
        LivingEntity entity = event.getEntity();
        MobEffectInstance instance = event.getEffectInstance();
        if (instance == null) {
            return;
        }
        MobEffect effect = instance.m_19544_();
        MobEffectCategory cate = effect.m_19483_();
        if (cate.equals((Object)PotionInit.BUFF) && !effect.equals(PotionInit.sandryon_bless) && entity.m_21023_(PotionInit.sandryon_bless)) {
            event.setCanceled(true);
            entity.m_21195_(PotionInit.sandryon_bless);
        }
    }

    @SubscribeEvent
    public static void healEvent(LivingHealEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity == null || !entity.m_21023_(PotionInit.increased_recovery)) {
            return;
        }
        float amount = event.getAmount();
        if (amount <= 0.0f) {
            return;
        }
        int level = entity.m_21124_(PotionInit.increased_recovery).m_19564_() + 1;
        event.setAmount(amount * (1.0f + (float)level * 0.25f));
    }

    @SubscribeEvent
    public static void knockBackEvent(LivingKnockBackEvent event) {
        LivingEntity entity = event.getEntity();
        if (!entity.m_21023_(PotionInit.resistance_blow) && !PotionEvent.hasHarness(entity)) {
            return;
        }
        int level = entity.m_21124_(PotionInit.resistance_blow).m_19564_() + 1;
        float strength = Math.max(0.0f, event.getStrength() - (float)level * 0.4f);
        event.setStrength(strength);
        if (strength <= 0.0f) {
            event.setRatioX(0.0);
            event.setRatioZ(0.0);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void fallEvent(LivingFallEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.f_19789_ > 0.0f && entity.m_21023_(PotionInit.resistance_blow)) {
            event.setDamageMultiplier(0.0f);
        }
    }

    public static boolean hasHarness(LivingEntity entity) {
        ItemStack feet = entity.m_6844_(EquipmentSlot.FEET);
        Item item = feet.m_41720_();
        if (!(item instanceof IHarness)) {
            return false;
        }
        IHarness harness = (IHarness)item;
        int mf = harness.getMF(feet);
        int useMF = 300;
        int costDown = Math.min(99, harness.getEnchantLevel(EnchantInit.mfCostDown, feet) * 7);
        if (costDown > 0) {
            useMF = (int)((float)useMF * ((float)(100 - costDown) / 100.0f));
        }
        if (mf < useMF) {
            return false;
        }
        harness.setMF(feet, mf - useMF);
        PlayerHelper.setPotion(entity, PotionInit.resistance_blow, harness.getTier(), 600);
        return true;
    }

    @SubscribeEvent
    public static void teleportEvent(EntityTeleportEvent event) {
        LivingEntity living;
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity) || !(living = (LivingEntity)entity).m_21023_(PotionInit.gravity)) {
            return;
        }
        event.setCanceled(true);
    }
}

