/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.event;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import sweetmagic.api.iitem.IWand;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.handler.PacketHandler;
import sweetmagic.init.block.sm.IrisCreation;
import sweetmagic.init.item.sm.SummonerWand;
import sweetmagic.packet.SummonerWandPKT;
import sweetmagic.packet.WandLeftClickPKT;

@Mod.EventBusSubscriber(modid="sweetmagic", value={Dist.CLIENT})
public class SMClickEvent {
    @SubscribeEvent
    public static void onLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        Player player = event.getEntity();
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (player.m_6144_() && item instanceof IWand) {
            SMClickEvent.ChangeSlot(new WandInfo(stack));
        } else if (item instanceof SummonerWand) {
            PacketHandler.sendToServer(new SummonerWandPKT());
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getEntity();
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (player.m_6144_() && item instanceof IWand) {
            event.setCanceled(true);
            SMClickEvent.ChangeSlot(new WandInfo(stack));
        } else if (item instanceof SummonerWand) {
            PacketHandler.sendToServer(new SummonerWandPKT());
            event.setCanceled(true);
        }
    }

    public static void ChangeSlot(WandInfo wandInfo) {
        wandInfo.getWand().setSelectSlot(wandInfo.getStack(), 0);
        PacketHandler.sendToServer(new WandLeftClickPKT());
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public static void clientTickEvent(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player.m_5446_().getString().equals("Konohairoha")) {
            player.f_19793_ = !player.m_6144_() ? 1.0f : 1.3f;
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getEntity();
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        Block upBlock = world.m_8055_(pos.m_7494_()).m_60734_();
        if (!(world.m_8055_(pos).m_60734_() instanceof CampfireBlock) || !(upBlock instanceof IrisCreation)) {
            return;
        }
        IrisCreation iris = (IrisCreation)upBlock;
        iris.actionBlock(world, pos.m_7494_(), player, player.m_21205_());
    }
}

