/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.event.SMUtilEvent;
import sweetmagic.handler.PacketHandler;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.item.magic.StartLightWand;
import sweetmagic.packet.StartLightWandPKT;
import sweetmagic.util.RenderUtil;

@Mod.EventBusSubscriber(modid="sweetmagic", value={Dist.CLIENT})
public class StarLightWandEvent
extends SMUtilEvent {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_misc.png");

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (!(item instanceof StartLightWand)) {
            return;
        }
        StartLightWand wand = (StartLightWand)item;
        event.setCanceled(true);
        if (player.m_6144_()) {
            PacketHandler.sendToServer(new StartLightWandPKT(0, event.getPos()));
        } else {
            PacketHandler.sendToServer(new StartLightWandPKT(1, event.getPos()));
            player.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public static void onLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        Player player = event.getEntity();
        if (!player.m_6144_()) {
            return;
        }
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (!(item instanceof StartLightWand)) {
            return;
        }
        StartLightWand wand = (StartLightWand)item;
        PacketHandler.sendToServer(new StartLightWandPKT(0, event.getPos()));
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void renderLevelLastEvent(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_() || !(stack.m_41720_() instanceof StartLightWand)) {
            return;
        }
        CompoundTag tags = stack.m_41783_();
        if (tags == null || !tags.m_128441_("startX") && !tags.m_128441_("endX") || !tags.m_128441_("blockId")) {
            return;
        }
        Level world = player.m_9236_();
        BlockState state = NbtUtils.m_129241_((CompoundTag)tags.m_128469_("state"));
        Block block = state.m_60734_();
        BlockPos startPos = tags.m_128441_("startX") ? new BlockPos(tags.m_128451_("startX"), tags.m_128451_("startY"), tags.m_128451_("startZ")) : new BlockPos(tags.m_128451_("endX"), tags.m_128451_("endY"), tags.m_128451_("endZ"));
        BlockPos endPos = tags.m_128441_("endX") ? new BlockPos(tags.m_128451_("endX"), tags.m_128451_("endY"), tags.m_128451_("endZ")) : new BlockPos(tags.m_128451_("startX"), tags.m_128451_("startY"), tags.m_128451_("startZ"));
        Iterable posList = BlockPos.m_121940_((BlockPos)startPos, (BlockPos)endPos);
        PoseStack pose = event.getPoseStack();
        MultiBufferSource.BufferSource buf = mc.m_91269_().m_110104_();
        Vec3 base = mc.f_91063_.m_109153_().m_90583_();
        int count = 0;
        boolean isExchange = tags.m_128471_("isExchange");
        boolean isFull = tags.m_128471_("isFull");
        pose.m_85836_();
        VertexConsumer ver = buf.m_6299_(RenderType.m_110504_());
        Vec3 rPos = base.m_82492_((double)startPos.m_123341_(), (double)startPos.m_123342_(), (double)startPos.m_123343_()).m_82520_((double)0.005f, (double)0.005f, (double)0.005f);
        pose.m_85837_(-rPos.m_7096_() + 1.0, -rPos.m_7098_() + 1.0, -rPos.m_7094_());
        int x = -startPos.m_123341_() + endPos.m_123341_();
        int y = -startPos.m_123342_() + endPos.m_123342_();
        int z = -startPos.m_123343_() + endPos.m_123343_();
        int addX = -1;
        int addY = -1;
        int addZ = 1;
        if (x != 0) {
            if (x > 0) {
                addX = -1;
            } else {
                x += addX;
                addX = 0;
            }
        }
        if (z != 0) {
            if (z > 0) {
                z -= addZ - 2;
                addZ = 0;
            } else {
                z -= addZ - 1;
                addZ = 1;
            }
        }
        if (y != 0 && y < 0) {
            y -= addY + 2;
            addY = 0;
        }
        LevelRenderer.m_109621_((PoseStack)pose, (VertexConsumer)ver, (double)addX, (double)addY, (double)addZ, (double)x, (double)y, (double)z, (float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f, (float)0.5f, (float)0.5f, (float)0.5f);
        pose.m_85849_();
        if (stack.m_150930_(ItemInit.wood_wand_b)) {
            return;
        }
        for (BlockPos pos : posList) {
            if (!isExchange && !world.m_46859_(pos) || isExchange && block == world.m_8055_(pos).m_60734_()) continue;
            Vec3 renderPos = base.m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_82520_((double)0.005f, (double)0.005f, (double)0.005f);
            pose.m_85836_();
            pose.m_85837_(-renderPos.m_7096_(), -renderPos.m_7098_(), -renderPos.m_7094_());
            pose.m_85841_(1.01f, 1.01f, 1.01f);
            if (isFull) {
                ++count;
                RenderUtil.renderTransBlock(pose, (MultiBufferSource)buf, RenderUtil.RenderColor.create(1000), state, 0.65f);
            } else {
                count += 10;
                RenderUtil.renderTransBlock(pose, (MultiBufferSource)buf, RenderUtil.RenderColor.create(1000), state);
            }
            pose.m_85849_();
            if (count <= 10000) continue;
            break;
        }
        RenderSystem.m_69465_();
        buf.m_109911_();
    }

    @SubscribeEvent
    public static void onWandRenderEvent(RenderGuiOverlayEvent.Post event) {
        Item item;
        if (!event.getOverlay().id().equals((Object)VanillaGuiOverlay.HOTBAR.id())) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player.m_5833_()) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof StartLightWand)) {
            return;
        }
        StartLightWand wand = (StartLightWand)item;
        PoseStack pose = event.getPoseStack();
        Matrix4f mat = pose.m_85850_().m_85861_();
        int height = event.getWindow().m_85446_();
        StarLightWandEvent.renderStart(TEX);
        StarLightWandEvent.drawTextured(mat, 8, height - 133, 114, 47, 18, 18);
        CompoundTag tags = stack.m_41784_();
        Block block = null;
        if (tags.m_128441_("blockId")) {
            block = wand.getBlock(tags);
            ItemRenderer render = mc.m_91291_();
            render.m_115218_(new ItemStack((ItemLike)block), 9, height - 132);
        }
        Font font = mc.f_91062_;
        String blockName = tags.m_128441_("blockId") ? block.m_49954_().getString() : StarLightWandEvent.getText("unregistered").getString();
        font.m_92763_(pose, (Component)StarLightWandEvent.getTipArray(StarLightWandEvent.getText("set_block").m_130940_(GREEN), StarLightWandEvent.getTip(blockName).m_130940_(WHITE)), 9.0f, (float)(height - 110), 0xFFFFFF);
        String start = tags.m_128441_("startX") ? tags.m_128451_("startX") + ", " + tags.m_128451_("startY") + ", " + tags.m_128451_("startZ") : StarLightWandEvent.getText("unregistered").getString();
        font.m_92763_(pose, (Component)StarLightWandEvent.getTipArray(StarLightWandEvent.getText("start_pos").m_130940_(GREEN), StarLightWandEvent.getTip(start).m_130940_(WHITE)), 9.0f, (float)(height - 99), 0xFFFFFF);
        String end = tags.m_128441_("endX") ? tags.m_128451_("endX") + ", " + tags.m_128451_("endY") + ", " + tags.m_128451_("endZ") : StarLightWandEvent.getText("unregistered").getString();
        font.m_92763_(pose, (Component)StarLightWandEvent.getTipArray(StarLightWandEvent.getText("end_pos").m_130940_(GREEN), StarLightWandEvent.getTip(end).m_130940_(WHITE)), 9.0f, (float)(height - 88), 0xFFFFFF);
        font.m_92763_(pose, (Component)StarLightWandEvent.getTipArray(StarLightWandEvent.getText("star_mode").m_130940_(GREEN), StarLightWandEvent.getText(tags.m_128471_("isExchange") ? "exchange_mode" : "set_mode").m_130940_(WHITE)), 9.0f, (float)(height - 77), 0xFFFFFF);
        int type = 3;
        if (!tags.m_128441_("startX")) {
            type = 0;
        } else if (!tags.m_128441_("endX")) {
            type = 1;
        } else if (!tags.m_128441_("blockId")) {
            type = 2;
        }
        font.m_92763_(pose, (Component)StarLightWandEvent.getText("startlight_wand_operation." + type).m_130940_(GOLD), 9.0f, (float)(height - 66), 0xFFFFFF);
    }

    @SubscribeEvent
    public static void renderTargetBlock(RenderHighlightEvent.Block event) {
        Item item;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof StartLightWand)) {
            return;
        }
        StartLightWand wand = (StartLightWand)item;
        PoseStack pose = event.getPoseStack();
        MultiBufferSource.BufferSource buf = mc.m_91269_().m_110104_();
        Vec3 base = mc.f_91063_.m_109153_().m_90583_();
        BlockHitResult result = event.getTarget();
        BlockPos pos = wand.getPos(event.getTarget().m_82425_(), result.m_82450_(), result.m_82434_());
        Vec3 renderPos = base.m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_82520_((double)0.005f, (double)0.005f, (double)0.005f);
        pose.m_85836_();
        pose.m_85837_(-renderPos.m_7096_(), -renderPos.m_7098_(), -renderPos.m_7094_());
        pose.m_85841_(1.01f, 1.01f, 1.01f);
        RenderUtil.renderBlock(pose, (MultiBufferSource)buf, RenderUtil.RenderColor.create(1000), BlockInit.select_block);
        pose.m_85849_();
    }
}

