/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.emagic.SMMagicType;
import sweetmagic.api.event.SMUtilEvent;
import sweetmagic.api.iitem.IMagicItem;
import sweetmagic.api.iitem.IPorch;
import sweetmagic.api.iitem.IWand;
import sweetmagic.api.iitem.info.MagicInfo;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.ItemInit;

@OnlyIn(value=Dist.CLIENT)
public class WandRenderEvent
extends SMUtilEvent {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_usergage.png");
    private static final ResourceLocation SCOPE = SweetMagicCore.getSRC("textures/gui/spyglass_scope.png");
    private static int tickTime = 0;
    private static final int SCOPE_TIME = 6;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onWandRenderEvent(RenderGuiOverlayEvent.Post event) {
        Item item;
        if (!event.getOverlay().id().equals((Object)VanillaGuiOverlay.HOTBAR.id())) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player.m_5833_()) {
            return;
        }
        ItemStack stack = IWand.getWand((Player)player);
        if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof IWand)) {
            return;
        }
        IWand wand = (IWand)item;
        ClientLevel world = mc.f_91073_;
        PoseStack pose = event.getPoseStack();
        Matrix4f mat = pose.m_85850_().m_85861_();
        int height = event.getWindow().m_85446_();
        int weight = event.getWindow().m_85445_();
        WandInfo wandInfo = new WandInfo(stack);
        ItemStack slotStack = wand.getSlotItem((Player)player, wandInfo);
        WandRenderEvent.renderStart(TEX);
        boolean isSneak = player.m_6144_();
        boolean isLeftSide = true;
        ItemStack nextStack = wand.getNextStack((Level)world, (Player)player, stack);
        ItemStack backStack = wand.getBackStack((Level)world, (Player)player, stack);
        tickTime = isSneak ? Math.min(20, ++tickTime) : Math.max(0, --tickTime);
        WandRenderEvent.renderGUI(mat, height, weight, isLeftSide, isSneak);
        int progress = wand.getMFProgressScaled(stack, 76);
        WandRenderEvent.renderMFProgress(mat, height, weight, isLeftSide, progress);
        int expProgress = wand.isCreativeWand() ? 76 : wand.getExpProgressScaled(stack, 76);
        WandRenderEvent.renderEXPProgress(mat, height, weight, isLeftSide, expProgress);
        if (!slotStack.m_41619_()) {
            IMagicItem magic;
            int addY = (int)((float)(isSneak ? -40 : Math.min(-40, tickTime)) * WandRenderEvent.getProgress(10));
            WandRenderEvent.renderSlotItem(mat, (Player)player, height, weight, new MagicInfo(slotStack), isLeftSide, addY);
            Item item2 = slotStack.m_41720_();
            if (item2 instanceof IMagicItem && (magic = (IMagicItem)item2).getMagicType() == SMMagicType.CHARGE) {
                WandRenderEvent.renderChargeProgress(mat, height, weight, isLeftSide, (Player)player);
            }
        }
        if ((isSneak || !isSneak) && tickTime >= 10) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)WandRenderEvent.getProgress(20));
            if (!nextStack.m_41619_()) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)TEX);
                WandRenderEvent.drawTextured(mat, 11, height - 131, 41, 69, 41, 40);
                WandRenderEvent.drawTextured(mat, 26, height - 95, 20, 121, 11, 12);
                WandRenderEvent.renderSlotItem(mat, (Player)player, height, weight, new MagicInfo(nextStack), isLeftSide, -84);
            }
            if (!backStack.m_41619_()) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)TEX);
                WandRenderEvent.drawTextured(mat, 11, height - 43, 41, 69, 41, 40);
                WandRenderEvent.drawTextured(mat, 26, height - 51, 5, 121, 11, 12);
                WandRenderEvent.renderSlotItem(mat, (Player)player, height, weight, new MagicInfo(backStack), isLeftSide, 4);
            }
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        WandRenderEvent.renderMFText(mc, pose, height, weight, wandInfo, isLeftSide);
        if (!slotStack.m_41619_()) {
            WandRenderEvent.renderMagicText(mc, pose, height, weight, slotStack, isLeftSide);
        }
        RenderSystem.m_69461_();
        int remaing = player.m_21212_();
        if (wand.isScope() && mc.f_91066_.m_92176_().m_90612_() && remaing != 0 && 72000 - player.m_21212_() > 6) {
            RenderSystem.m_69465_();
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_69453_();
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)SCOPE);
            Tesselator tes = Tesselator.m_85913_();
            BufferBuilder buf = tes.m_85915_();
            float f = Math.min(weight, height);
            float f1 = Math.min((float)weight / f, (float)height / f) * 0.8f;
            float f2 = f * f1;
            float f3 = f * f1;
            float f4 = ((float)weight - f2) / 2.0f;
            float f5 = ((float)height - f3) / 2.0f;
            float f6 = f4 + f2;
            float f7 = f5 + f3;
            buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            buf.m_5483_((double)f4, (double)f7, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
            buf.m_5483_((double)f6, (double)f7, -90.0).m_7421_(1.0f, 1.0f).m_5752_();
            buf.m_5483_((double)f6, (double)f5, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
            buf.m_5483_((double)f4, (double)f5, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
            tes.m_85914_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            RenderSystem.m_69472_();
            RenderSystem.m_69493_();
            RenderSystem.m_69458_((boolean)true);
            RenderSystem.m_69482_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void renderGUI(Matrix4f mat, int height, int weight, boolean isLeftSide, boolean isSneak) {
        int addY = (int)((float)(isSneak ? 40 : -Math.min(-40, tickTime)) * WandRenderEvent.getProgress(10));
        int posX = isLeftSide ? 10 : weight - 247;
        WandRenderEvent.drawTextured(mat, posX, height - 47 - addY, 0, 0, 41, 40);
        WandRenderEvent.drawTextured(mat, posX + 44, height - 38, 44, 13, 77, 36);
    }

    public static void renderMFProgress(Matrix4f mat, int height, int weight, boolean isLeftSide, int progress) {
        int posX = isLeftSide ? 54 : weight - 202;
        WandRenderEvent.drawTextured(mat, posX, height - 25, 0, 50, progress, 14);
    }

    public static void renderEXPProgress(Matrix4f mat, int height, int weight, boolean isLeftSide, int progress) {
        int posX = isLeftSide ? 54 : weight - 202;
        WandRenderEvent.drawTextured(mat, posX, height - 11, 0, 64, progress, 4);
    }

    public static void renderChargeProgress(Matrix4f mat, int height, int weight, boolean isLeftSide, Player player) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEX);
        int posX = isLeftSide ? 130 : weight - 202;
        WandRenderEvent.drawTextured(mat, posX, height - 22, 120, 29, 5, 15);
        int remainingTick = player.m_21212_();
        if (remainingTick != 0) {
            int progress;
            IPorch portch;
            Item item;
            float rate = 20.0f;
            ItemStack leg = player.m_6844_(EquipmentSlot.LEGS);
            if (!leg.m_41619_() && (item = leg.m_41720_()) instanceof IPorch && (portch = (IPorch)item).hasAcce(leg, ItemInit.magician_quillpen)) {
                rate /= 4.0f;
            }
            WandRenderEvent.drawTextured(mat, posX, height - 22 + 15 - progress, 76 + ((progress = Math.min(15, (int)(15.0f * (rate - ((float)remainingTick - (72000.0f - rate))) / rate))) == 15 ? 8 : 0), 53 + (progress == 15 ? 0 : 15 - progress), 5, progress);
        }
    }

    public static void renderSlotItem(Matrix4f mat, Player player, int height, int weight, MagicInfo magicInfo, boolean isLeftSide, int addY) {
        int texSize = 32;
        ItemStack magicStack = magicInfo.getStack();
        IMagicItem smItem = magicInfo.getMagicItem();
        RenderSystem.m_157456_((int)0, (ResourceLocation)smItem.getResource());
        int posX = isLeftSide ? 15 : weight - 242;
        WandRenderEvent.drawTextured(mat, posX, height - 43 + addY, 0, 0, texSize, texSize, texSize);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEX);
        if (!smItem.isShirink()) {
            int tier = smItem.getTier();
            String name = "";
            switch (tier) {
                case 1: {
                    name = "frame_1";
                    break;
                }
                case 2: {
                    name = "frame_2";
                    break;
                }
                case 3: {
                    name = "frame_3";
                    break;
                }
                case 4: {
                    name = "frame_4";
                    break;
                }
                case 5: {
                    name = "frame_5";
                }
            }
            if (!name.equals("")) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)SweetMagicCore.getSRC("textures/item/" + name + ".png"));
                WandRenderEvent.drawTextured(mat, posX, height - 43 + addY, 0, 0, texSize, texSize, 32.0f);
            }
        }
        if (!smItem.isNoRecast(magicStack)) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEX);
            posX = isLeftSide ? 15 : weight - 242;
            int x = smItem.isImmedFlag(magicStack) ? 88 : 5;
            int progress = (int)(32.0f * ((float)smItem.getRecastTime(magicStack) / (float)smItem.getMaxRecastTime())) + 1;
            WandRenderEvent.drawTextured(mat, posX, height - 11 - progress + addY, x, 73, 32, progress);
        }
    }

    public static void renderMFText(Minecraft mc, PoseStack pose, int height, int weight, WandInfo wandInfo, boolean isLeftSide) {
        Font font = mc.f_91062_;
        String text = String.format("%,d", wandInfo.getWand().getMF(wandInfo.getStack())) + "MF";
        int posX = isLeftSide ? 72 : weight - 192;
        font.m_92750_(pose, text, (float)posX, (float)(height - 33), 0xFFFFFF);
    }

    public static void renderMagicText(Minecraft mc, PoseStack pose, int height, int weight, ItemStack slotItem, boolean isLeftSide) {
        Font font = mc.f_91062_;
        int posX = isLeftSide ? 65 : weight - 192;
        font.m_92763_(pose, slotItem.m_41786_(), (float)posX, (float)(height - 44), 0xFFFFFF);
    }

    public static float getProgress(int maxTime) {
        return Math.min(1.0f, (float)tickTime / (float)maxTime);
    }

    @SubscribeEvent
    public static void onFOVEvent(ComputeFovModifierEvent event) {
        IWand wand;
        Item item;
        Player player = event.getPlayer();
        Minecraft mc = Minecraft.m_91087_();
        int remaing = player.m_21212_();
        if (!mc.f_91066_.m_92176_().m_90612_() || remaing == 0 || remaing > 71994) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof IWand) || !(wand = (IWand)item).isScope()) {
            return;
        }
        event.setNewFovModifier(event.getFovModifier() / 4.0f);
    }
}

