/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.handler;

import java.util.Optional;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import sweetmagic.SweetMagicCore;
import sweetmagic.packet.AddSPtoServerPKT;
import sweetmagic.packet.AetherLampLightPKT;
import sweetmagic.packet.BottlerPKT;
import sweetmagic.packet.BroomMovePKT;
import sweetmagic.packet.CleroPKT;
import sweetmagic.packet.CompasPKT;
import sweetmagic.packet.CookStatusPKT;
import sweetmagic.packet.FurnitureCraftPKT;
import sweetmagic.packet.IPacket;
import sweetmagic.packet.KeyPressPKT;
import sweetmagic.packet.MouseSclorPKT;
import sweetmagic.packet.NoteBuyPKT;
import sweetmagic.packet.PhonePKT;
import sweetmagic.packet.StartLightWandPKT;
import sweetmagic.packet.SummonerWandPKT;
import sweetmagic.packet.WandLeftClickPKT;
import sweetmagic.packet.WoodChestLootPKT;

public class PacketHandler {
    private static int index;
    private static final String PRO_VER;
    private static final SimpleChannel HANDLER;

    public static void register() {
        PacketHandler.registerClientToServer(KeyPressPKT.class, KeyPressPKT::decode);
        PacketHandler.registerClientToServer(MouseSclorPKT.class, MouseSclorPKT::decode);
        PacketHandler.registerClientToServer(WandLeftClickPKT.class, WandLeftClickPKT::decode);
        PacketHandler.registerClientToServer(StartLightWandPKT.class, StartLightWandPKT::decode);
        PacketHandler.registerClientToServer(CleroPKT.class, CleroPKT::decode);
        PacketHandler.registerClientToServer(CompasPKT.class, CompasPKT::decode);
        PacketHandler.registerClientToServer(PhonePKT.class, PhonePKT::decode);
        PacketHandler.registerClientToServer(WoodChestLootPKT.class, WoodChestLootPKT::decode);
        PacketHandler.registerClientToServer(FurnitureCraftPKT.class, FurnitureCraftPKT::decode);
        PacketHandler.registerClientToServer(BottlerPKT.class, BottlerPKT::decode);
        PacketHandler.registerClientToServer(AetherLampLightPKT.class, AetherLampLightPKT::decode);
        PacketHandler.registerClientToServer(SummonerWandPKT.class, SummonerWandPKT::decode);
        PacketHandler.registerClientToServer(AddSPtoServerPKT.class, AddSPtoServerPKT::decode);
        PacketHandler.registerClientToServer(NoteBuyPKT.class, NoteBuyPKT::decode);
        PacketHandler.registerClientToServer(BroomMovePKT.class, BroomMovePKT::decode);
        PacketHandler.registerServerToClient(CookStatusPKT.class, CookStatusPKT::decode);
    }

    private static <MSG extends IPacket> void registerClientToServer(Class<MSG> type, Function<FriendlyByteBuf, MSG> decoder) {
        PacketHandler.registerMessage(type, decoder, NetworkDirection.PLAY_TO_SERVER);
    }

    private static <MSG extends IPacket> void registerServerToClient(Class<MSG> type, Function<FriendlyByteBuf, MSG> decoder) {
        PacketHandler.registerMessage(type, decoder, NetworkDirection.PLAY_TO_CLIENT);
    }

    private static <MSG extends IPacket> void registerMessage(Class<MSG> type, Function<FriendlyByteBuf, MSG> deco, NetworkDirection network) {
        HANDLER.registerMessage(index++, type, IPacket::encode, deco, IPacket::handle, Optional.of(network));
    }

    public static <MSG extends IPacket> void sendToServer(MSG msg) {
        HANDLER.sendToServer(msg);
    }

    public static <MSG extends IPacket> void sendTo(MSG msg, ServerPlayer player) {
        HANDLER.sendTo(msg, player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
    }

    static {
        PRO_VER = Integer.toString(3);
        HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)SweetMagicCore.getSRC("main_channel")).clientAcceptedVersions(PRO_VER::equals).serverAcceptedVersions(PRO_VER::equals).networkProtocolVersion(() -> PRO_VER).simpleChannel();
    }
}

