/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.predicates.AlternativeLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.ItemInit;

@Mod.EventBusSubscriber(modid="sweetmagic")
public class LootInit {
    public static List<ResourceLocation> lootList = new ArrayList<ResourceLocation>();

    public static void init() {
        LootInit.setLoot("biginer/biginer_chest");
        LootInit.setLoot("witchhouse/witchhouse_chest_0");
        LootInit.setLoot("witchhouse/witchhouse_chest_1");
        LootInit.setLoot("skyland/skyland_chest_0");
        LootInit.setLoot("skyland/skyland_chest_1");
        LootInit.setLoot("skyland/skyland_old");
        LootInit.setLoot("tomb/tomb_chest_0");
        LootInit.setLoot("tomb/tomb_chest_1");
        LootInit.setLoot("tomb/tomb_chest_2");
        LootInit.setLoot("submarine_ruins/submarine_ruins");
        LootInit.setLoot("ruins_site/ruins_site_light");
        LootInit.setLoot("ruins_site/ruins_site_fire");
        LootInit.setLoot("well/well_0");
        LootInit.setLoot("well/well_1");
        LootInit.setLoot("witch_tower/witch_tower_0");
        LootInit.setLoot("witch_tower/witch_tower_1");
        LootInit.setLoot("witch_tower/witch_tower_2");
        LootInit.setLoot("labyrinth/labyrinth_0");
        LootInit.setLoot("labyrinth/labyrinth_1");
        LootInit.setLoot("labyrinth/labyrinth_2");
        LootInit.setLoot("desert_mine/mine_0");
        LootInit.setLoot("desert_mine/mine_1");
        LootInit.setLoot("desert_mine/mine_2");
        LootInit.setLoot("ruins_site/ruins_site_wind_0");
        LootInit.setLoot("ruins_site/ruins_site_wind_1");
        LootInit.setLoot("ruins_site/ruins_site_wind_2");
        LootInit.setLoot("arena/arena_0");
        LootInit.setLoot("arena/arena_1");
        LootInit.setLoot("witch_large_house/chest_0");
        LootInit.setLoot("witch_large_house/chest_1");
        LootInit.setLoot("witch_large_house/chest_2");
        LootInit.setLoot("well_old/well_0");
        LootInit.setLoot("well_old/well_1");
        LootInit.setLoot("well_old/well_2");
        LootInit.setLoot("well_old/well_0");
        LootInit.setLoot("well_old/well_1");
        LootInit.setLoot("white_silver_house/house_0");
        LootInit.setLoot("white_silver_house/house_1");
        LootInit.setLoot("white_silver_house/house_2");
        LootInit.setLoot("castle/castle_0");
        LootInit.setLoot("castle/castle_1");
        LootInit.setLoot("castle/castle_2");
        LootInit.setLoot("wizard_house/house_0");
        LootInit.setLoot("wizard_house/house_1");
        LootInit.setLoot("wizard_house/house_2");
        LootInit.setLoot("wizard_fortress/fortress_0");
        LootInit.setLoot("wizard_fortress/fortress_1");
        LootInit.setLoot("wizard_fortress/fortress_2");
        LootInit.setLoot("labyrinth_large/labyrinth_0");
        LootInit.setLoot("labyrinth_large/labyrinth_1");
        LootInit.setLoot("labyrinth_large/labyrinth_2");
        LootInit.setLoot("labyrinth_large/labyrinth_3");
        LootInit.setLoot("pyramid/pyramid_0");
        LootInit.setLoot("pyramid/pyramid_1");
        LootInit.setLoot("pyramid/pyramid_2");
    }

    public static void setLoot(String name) {
        lootList.add(SweetMagicCore.getSRC("chests/" + name));
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation name = event.getName();
        if (LootInit.is(name, BuiltInLootTables.f_78723_, BuiltInLootTables.f_78720_, BuiltInLootTables.f_78721_)) {
            AlternativeLootItemCondition.Builder alt = LootInit.getAlt(Biomes.f_48208_, Biomes.f_48174_, Biomes.f_48168_, Biomes.f_48171_, Biomes.f_48172_, Biomes.f_48170_, Biomes.f_48225_, Biomes.f_48211_, Biomes.f_48167_, Biomes.f_48166_);
            LootInit.addLootTable(event.getTable(), LootInit.getLoot((ItemLike)ItemInit.shrimp, 9, alt));
            LootInit.addLootTable(event.getTable(), LootInit.getLoot((ItemLike)ItemInit.seaweed, 7, alt));
        }
    }

    public static boolean is(ResourceLocation name, ResourceLocation ... targetArray) {
        for (ResourceLocation target : targetArray) {
            if (!name.equals((Object)target)) continue;
            return true;
        }
        return false;
    }

    public static AlternativeLootItemCondition.Builder getAlt(ResourceKey<Biome> ... biomesArray) {
        ArrayList<LootItemCondition.Builder> buildList = new ArrayList<LootItemCondition.Builder>();
        for (ResourceKey<Biome> biome : biomesArray) {
            buildList.add(LocationCheck.m_81725_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52656_(biome)));
        }
        return AlternativeLootItemCondition.m_81481_((LootItemCondition.Builder[])buildList.toArray(new LootItemCondition.Builder[buildList.size()]));
    }

    public static LootPoolEntryContainer getLoot(ItemLike item, int weiight, AlternativeLootItemCondition.Builder alt) {
        return ((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)item).m_79707_(weiight).m_79080_((LootItemCondition.Builder)alt)).m_7512_();
    }

    public static void addLootTable(LootTable loot, LootPoolEntryContainer ... entry) {
        LootPool pool = Objects.requireNonNull(loot.getPool("main"));
        try {
            for (LootPoolEntryContainer lootEntry : entry) {
                LootInit.addEntryToLootPool(pool, lootEntry);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private static void addEntryToLootPool(LootPool pool, LootPoolEntryContainer entry) throws IllegalAccessException {
        Field entries = ObfuscationReflectionHelper.findField(LootPool.class, (String)"f_79023_");
        LootPoolEntryContainer[] entryArray = (LootPoolEntryContainer[])entries.get(pool);
        ArrayList<LootPoolEntryContainer> newLoot = new ArrayList<LootPoolEntryContainer>(List.of(entryArray));
        if (newLoot.stream().anyMatch(e -> e == entry)) {
            throw new RuntimeException("Attempted to add a duplicate entry to pool: " + entry);
        }
        newLoot.add(entry);
        entries.set(pool, newLoot.toArray(new LootPoolEntryContainer[0]));
    }
}

