/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.base;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.iblock.ISMCookBlock;
import sweetmagic.api.iitem.IPorch;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.block.base.BaseFaceBlock;
import sweetmagic.init.block.sm.Stove;
import sweetmagic.init.capability.icap.ICookingStatus;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileAbstractSMCook;

public abstract class BaseCookBlock
extends BaseFaceBlock
implements EntityBlock,
ISMCookBlock {
    public static final IntegerProperty COOK = IntegerProperty.m_61631_((String)"cook", (int)0, (int)2);

    public BaseCookBlock(String name) {
        super(name, BaseCookBlock.setState(Material.f_76279_, SoundType.f_56743_, 1.0f, 8192.0f));
        this.m_49959_((BlockState)this.setState().m_61124_((Property)COOK, (Comparable)Integer.valueOf(0)));
        BlockInit.BlockInfo.create(this, SweetMagicCore.smFoodTab, name);
    }

    public BaseCookBlock(String name, CreativeModeTab tab) {
        super(name, BaseCookBlock.setState(Material.f_76279_, SoundType.f_56743_, 1.0f, 8192.0f));
        this.m_49959_((BlockState)this.setState().m_61124_((Property)COOK, (Comparable)Integer.valueOf(0)));
        BlockInit.BlockInfo.create(this, tab, name);
    }

    public void setState(Level world, BlockPos pos, int data) {
        BlockState state = world.m_8055_(pos);
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)COOK, (Comparable)Integer.valueOf(data)), 3);
    }

    public int getState(BlockState state) {
        return (Integer)state.m_61143_((Property)COOK);
    }

    @Override
    public boolean canRightClick(Player player, ItemStack stack) {
        return true;
    }

    @Override
    public void onRemove(Level world, BlockPos pos, BlockState state, TileAbstractSM tile) {
        if (tile instanceof TileAbstractSMCook) {
            TileAbstractSMCook cook = (TileAbstractSMCook)tile;
            this.spawnItemList(world, pos, cook.getDropList());
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> build) {
        build.m_61104_(new Property[]{FACING, COOK});
    }

    public boolean isUnderStove(Level world, BlockPos pos) {
        return this.getBlock(world, pos.m_7495_()) instanceof Stove;
    }

    public boolean hasFork(Player player) {
        Item item;
        ItemStack leg = player.m_6844_(EquipmentSlot.LEGS);
        if (!leg.m_41619_() && (item = leg.m_41720_()) instanceof IPorch) {
            IPorch porch = (IPorch)item;
            return porch.hasAcce(leg, ItemInit.mysterious_fork);
        }
        return false;
    }

    public void spawnXp(Player player, List<ItemStack> outList, boolean hasFok) {
        if (!hasFok) {
            return;
        }
        int xp = 0;
        Level world = player.m_9236_();
        for (ItemStack stack : outList) {
            Item item = stack.m_41720_();
            if (!item.m_41472_()) continue;
            FoodProperties food = item.m_41473_();
            float amount = Math.max((float)food.m_38744_(), 1.0f) * Math.max(food.m_38745_(), 0.1f) * (float)stack.m_41613_() * 0.2f;
            xp += (int)Math.max(1.0f, amount);
        }
        if (xp <= 0) {
            return;
        }
        int cookLevel = ICookingStatus.getState((LivingEntity)player).getCookLevel();
        float rate = 1.0f + (float)cookLevel * 0.05f;
        ExperienceOrb entity = new ExperienceOrb(world, player.m_20185_(), player.m_20186_(), player.m_20189_(), (int)((float)xp * rate));
        world.m_7967_((Entity)entity);
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        toolTip.add((Component)this.getText("cook_block").m_130940_(GREEN));
    }
}

