/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.base;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.iblock.ITileMF;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.block.base.BaseFaceBlock;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileSMMagic;

public abstract class BaseMFBlock
extends BaseFaceBlock
implements EntityBlock {
    public BaseMFBlock(String name) {
        super(name, BaseMFBlock.setState(Material.f_76283_, SoundType.f_56743_, 1.0f, 8192.0f));
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
        BlockInit.BlockInfo.create(this, SweetMagicCore.smMagicTab, name);
    }

    public BaseMFBlock(String name, boolean flag) {
        super(name, BaseMFBlock.setState(Material.f_76283_, SoundType.f_56743_, 1.0f, 8192.0f));
        BlockInit.BlockInfo.create(this, SweetMagicCore.smMagicTab, name);
    }

    public BaseMFBlock(String name, BlockBehaviour.Properties props) {
        super(name, props);
        BlockInit.BlockInfo.create(this, SweetMagicCore.smMagicTab, name);
    }

    public boolean canRightClick(Level world, BlockPos pos, Player player, ItemStack stack) {
        return true;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!this.canRightClick(world, pos, player, stack)) {
            return InteractionResult.PASS;
        }
        if (stack.m_41619_()) {
            this.actionBlock(world, pos, player, stack);
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        CompoundTag tags = stack.m_41783_();
        if (tags == null || !tags.m_128441_("X") || !stack.m_150930_(ItemInit.mf_stuff)) {
            if (stack.m_150930_(ItemInit.mf_stuff)) {
                return this.setBlockPos(world, tags, stack, player, pos);
            }
            this.actionBlock(world, pos, player, stack);
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        BlockEntity tile = world.m_7702_(pos);
        if (tile == null || !(tile instanceof ITileMF)) {
            return InteractionResult.PASS;
        }
        ITileMF mfBlock = (ITileMF)tile;
        if (mfBlock.getReceive()) {
            ITileMF sendMFBlock;
            BlockPos tilePos = new BlockPos(tags.m_128451_("X"), tags.m_128451_("Y"), tags.m_128451_("Z"));
            if (tilePos.m_123341_() == pos.m_123341_() && tilePos.m_123342_() == pos.m_123342_() && tilePos.m_123343_() == pos.m_123343_()) {
                return InteractionResult.PASS;
            }
            BlockEntity blockEntity = world.m_7702_(tilePos);
            if (blockEntity instanceof ITileMF && (sendMFBlock = (ITileMF)blockEntity).getPosList().contains(pos)) {
                return InteractionResult.PASS;
            }
            mfBlock.addPosList(tilePos);
            mfBlock.sentClient();
            tags.m_128473_("tick");
            tags.m_128473_("X");
            tags.m_128473_("Y");
            tags.m_128473_("Z");
            if (!world.m_5776_()) {
                player.m_213846_((Component)this.getText("posregi").m_130940_(GREEN));
            } else {
                player.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                this.spawnParticl(world, pos, world.m_213780_());
            }
        } else {
            this.setBlockPos(world, tags, stack, player, pos);
        }
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    }

    public InteractionResult setBlockPos(Level world, CompoundTag tags, ItemStack stack, Player player, BlockPos pos) {
        if (tags == null) {
            stack.m_41751_(new CompoundTag());
            tags = stack.m_41783_();
        }
        tags.m_128405_("tick", player.f_19797_ % 30);
        tags.m_128405_("X", pos.m_123341_());
        tags.m_128405_("Y", pos.m_123342_());
        tags.m_128405_("Z", pos.m_123343_());
        if (!world.m_5776_()) {
            player.m_213846_((Component)this.getText("posset").m_130940_(GOLD));
        } else {
            player.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            this.spawnParticl(world, pos, world.m_213780_());
        }
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    }

    public void spawnParticl(Level world, BlockPos pos, RandomSource rand) {
        for (int i = 0; i < 16; ++i) {
            float f1 = (float)pos.m_123341_() + 0.5f;
            float f2 = (float)pos.m_123342_() + 0.25f + rand.m_188501_() * 0.5f;
            float f3 = (float)pos.m_123343_() + 0.5f;
            float x = (rand.m_188501_() - rand.m_188501_()) * 0.15f;
            float z = (rand.m_188501_() - rand.m_188501_()) * 0.15f;
            world.m_7106_((ParticleOptions)ParticleInit.NORMAL, (double)f1, (double)f2, (double)f3, (double)x, 0.0, (double)z);
        }
    }

    @Override
    protected boolean isDrop() {
        return false;
    }

    @Override
    public void onRemove(Level world, BlockPos pos, BlockState state, TileAbstractSM base) {
        if (base instanceof TileSMMagic) {
            TileSMMagic tile = (TileSMMagic)base;
            ItemStack stack = this.setTagStack(tile, new ItemStack((ItemLike)this));
            this.spawnItem(world, pos, stack);
        }
    }

    public ItemStack setTagStack(TileSMMagic tile, ItemStack stack) {
        if (tile.isInfoEmpty()) {
            return stack;
        }
        CompoundTag tags = tile.m_187482_();
        if (tags.m_128441_(tile.POST)) {
            tags.m_128473_(tile.POST);
        }
        stack.m_41700_("BlockEntityTag", (Tag)tags);
        stack.m_41783_().m_128405_("mf", tile.getMF());
        return stack;
    }

    public int getTier() {
        return 1;
    }

    public int getMaxMF() {
        return 10000;
    }

    @Override
    public void m_5871_(ItemStack stack, @Nullable BlockGetter get, List<Component> toolTip, TooltipFlag flag) {
        super.m_5871_(stack, get, toolTip, flag);
        CompoundTag tags = stack.m_41783_();
        this.addTip(toolTip, stack, tags);
        toolTip.add((Component)this.empty());
        toolTip.add((Component)this.tierTip(this.getTier()));
        toolTip.add((Component)this.getTipArray(new Object[]{this.getText("maxmf"), ": ", this.getLabel(this.format(this.getMaxMF()), WHITE), GREEN}));
        int mf = tags != null ? tags.m_128451_("mf") : 0;
        toolTip.add((Component)this.getTipArray(new Object[]{this.format(mf), this.getLabel("MF", GREEN), WHITE}));
    }

    public void addTip(List<Component> toolTip, ItemStack stack, CompoundTag tags) {
        toolTip.add((Component)this.getTipArray(new Object[]{this.getText(this.name), GREEN}));
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int par1, int par2) {
        super.m_8133_(state, world, pos, par1, par2);
        BlockEntity tile = world.m_7702_(pos);
        return tile == null ? false : tile.m_7531_(par1, par2);
    }

    @Override
    public float getEnchantPower() {
        return switch (this.getTier()) {
            case 2 -> 2.5f;
            case 3 -> 5.0f;
            default -> 1.0f;
        };
    }

    public boolean keepTileInfo() {
        return false;
    }

    public ItemStack inheritingNBT(ItemStack oldStack, ItemStack newStack) {
        return newStack;
    }
}

