/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import sweetmagic.api.util.ISMTip;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.util.ItemHelper;

public class BaseSMBlock
extends Block
implements ISMTip {
    protected final String name;

    public BaseSMBlock(String name, BlockBehaviour.Properties pro) {
        super(pro);
        this.name = name;
    }

    public String getRegistryName() {
        return this.name;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        return this.onUse(world, pos, player, hand);
    }

    public InteractionResult onUse(Level world, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.canRightClick(player, stack)) {
            return InteractionResult.PASS;
        }
        boolean actionFlag = this.actionBlock(world, pos, player, stack);
        return actionFlag ? InteractionResult.m_19078_((boolean)world.m_5776_()) : InteractionResult.PASS;
    }

    public boolean canRightClick(Player player, ItemStack stack) {
        return false;
    }

    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        return false;
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder build) {
        if (!this.isDrop()) {
            return new ArrayList<ItemStack>();
        }
        return this.getDropList();
    }

    public List<ItemStack> getDropList() {
        return Arrays.asList(new ItemStack((ItemLike)this));
    }

    protected boolean isDrop() {
        return true;
    }

    public void spawnItemList(Level world, BlockPos pos, List<ItemStack> stackList) {
        if (world.m_5776_()) {
            return;
        }
        ItemHelper.compactItemListNoStacksize(stackList);
        stackList.forEach(s -> this.spawnItem(world, pos, (ItemStack)s));
    }

    public void spawnItem(Level world, BlockPos pos, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        ItemEntity entity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack.m_41777_());
        entity.m_32061_();
        entity.m_149678_();
        world.m_7967_((Entity)entity);
    }

    public void playerSound(Level world, BlockPos pos, SoundEvent sound, float vol, float pitch) {
        world.m_5594_(null, pos, sound, SoundSource.BLOCKS, vol, pitch);
    }

    public Block getBlock(Level world, BlockPos pos) {
        return world.m_8055_(pos).m_60734_();
    }

    public TileAbstractSM getTile(Level world, BlockPos pos) {
        TileAbstractSM tile;
        BlockEntity blockEntity = world.m_7702_(pos);
        return blockEntity instanceof TileAbstractSM ? (tile = (TileAbstractSM)blockEntity) : null;
    }

    public <T extends TileAbstractSM> T getTile(BlockEntityType.BlockEntitySupplier<T> tiType, Level world, BlockPos pos) {
        TileAbstractSM tile;
        BlockEntity blockEntity = world.m_7702_(pos);
        return (T)(blockEntity instanceof TileAbstractSM ? (tile = (TileAbstractSM)blockEntity) : null);
    }

    public boolean isRSStop() {
        return false;
    }

    public BlockEntityType<? extends TileAbstractSM> getTileType() {
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        BlockEntityType<? extends TileAbstractSM> tileType = this.getTileType();
        return tileType != null ? this.createMailBoxTicker(world, type, tileType) : null;
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> type1, BlockEntityType<E> type2, BlockEntityTicker<? super E> ticker) {
        return type2 == type1 ? ticker : null;
    }

    @Nullable
    protected <T extends BlockEntity> BlockEntityTicker<T> createMailBoxTicker(Level world, BlockEntityType<T> tileType, BlockEntityType<? extends TileAbstractSM> grill) {
        return BaseSMBlock.createTickerHelper(tileType, grill, world.m_5776_() ? TileAbstractSM::clientTick : TileAbstractSM::serverTick);
    }

    public void openGUI(Level world, BlockPos pos, Player player, MenuProvider menu) {
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)menu, (BlockPos)pos);
    }

    public static BlockBehaviour.Properties setState(Material material) {
        return BlockBehaviour.Properties.m_60939_((Material)material);
    }

    public static BlockBehaviour.Properties setState(Material material, SoundType sound, float destroyTime, float explosionResist) {
        return BaseSMBlock.setState(material).m_60918_(sound).m_60913_(destroyTime, explosionResist).m_60955_();
    }

    public static BlockBehaviour.Properties setState(Material material, SoundType sound, float destroyTime, float explosionResist, int lightLevel) {
        return BaseSMBlock.setState(material, sound, destroyTime, explosionResist).m_60953_(l -> lightLevel);
    }

    public Block getBlock(ItemStack stack) {
        return ((BlockItem)stack.m_41720_()).m_40614_();
    }

    public Block getBlock(LevelAccessor world, BlockPos pos) {
        return world.m_8055_(pos).m_60734_();
    }

    public void blockSound(Level world, Block block, BlockPos pos, Player player) {
        SoundType sound = this.getSoundType(block.m_49966_(), (LevelReader)world, pos, (Entity)player);
        this.playerSound(world, pos, sound.m_56777_(), (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
    }

    @Deprecated
    public void m_6810_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        TileAbstractSM tile;
        if (!state.m_60713_(newState.m_60734_()) && !world.m_5776_() && (tile = this.getTile(world, pos)) != null) {
            this.onRemove(world, pos, state, tile);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public boolean isKeepTile() {
        return false;
    }

    public void onRemove(Level world, BlockPos pos, BlockState state, TileAbstractSM tile) {
        if (!this.isKeepTile()) {
            return;
        }
        this.spawnItem(world, pos, tile.getDropStack(new ItemStack((ItemLike)this)));
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader world, BlockPos pos) {
        return this.getEnchantPower();
    }

    public float getEnchantPower() {
        return 0.0f;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter get, List<Component> toolTip, TooltipFlag flag) {
        this.addBlockTip(toolTip);
    }

    public void addBlockTip(List<Component> toolTip) {
        if (this.getEnchantPower() > 0.0f) {
            toolTip.add((Component)this.getTipArray(new Object[]{this.getText("enchant_power"), ": ", this.getLabel(Float.valueOf(this.getEnchantPower()), WHITE), GOLD}));
        }
        if (this.isRSStop()) {
            toolTip.add((Component)this.getText("rs_stop").m_130940_(RED));
        }
    }
}

