/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.crop;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.PlantType;
import sweetmagic.api.iblock.ISMCrop;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.block.base.BaseSMBlock;
import sweetmagic.init.item.sm.SMSickle;

public class MagiaFlower
extends BushBlock
implements ISMCrop {
    private final int data;
    private int chance;
    private static final VoxelShape[] CROP_VEXE = new VoxelShape[]{Block.m_49796_((double)1.6, (double)0.0, (double)1.6, (double)14.4, (double)1.0, (double)14.4), Block.m_49796_((double)1.6, (double)0.0, (double)1.6, (double)14.4, (double)5.0, (double)14.4), Block.m_49796_((double)1.6, (double)0.0, (double)1.6, (double)14.4, (double)7.0, (double)14.4), Block.m_49796_((double)1.6, (double)0.0, (double)1.6, (double)14.4, (double)10.0, (double)14.4)};

    public MagiaFlower(String name, int data, int chance) {
        super(BaseSMBlock.setState(Material.f_76300_, SoundType.f_56740_, 0.0f, 8192.0f).m_60910_().m_60977_());
        this.data = data;
        this.chance = chance;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.getSMMaxAge(), (Comparable)Integer.valueOf(0)));
        BlockInit.BlockInfo.create((Block)this, null, name);
    }

    @Override
    public ItemLike getCrop() {
        return switch (this.data) {
            case 1 -> ItemInit.moonblossom_petal;
            case 2 -> ItemInit.dm_flower;
            default -> ItemInit.sannyflower_petal;
        };
    }

    @Override
    public ItemLike getSeed() {
        return switch (this.data) {
            case 1 -> ItemInit.moonblossom_seed;
            case 2 -> ItemInit.drizzly_mysotis_seed;
            default -> ItemInit.sannyflower_seed;
        };
    }

    @Override
    public int getMaxBlockState() {
        return 3;
    }

    @Override
    public IntegerProperty getSMMaxAge() {
        return ISMCrop.AGE3;
    }

    @Override
    public void setGlowChance(int chance) {
        this.chance = chance;
    }

    @Override
    public int getGlowChange() {
        return this.chance;
    }

    @Override
    public int RCSetState() {
        return 1;
    }

    @Override
    public BlockState getDefault() {
        return this.m_49966_();
    }

    @Override
    public int getDropValue(RandomSource rand, int fortune) {
        return Math.max(1, rand.m_188503_(3) + 1);
    }

    public ItemStack m_7397_(BlockGetter get, BlockPos pos, BlockState state) {
        return new ItemStack(this.getCrop());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext col) {
        return CROP_VEXE[this.getNowState(state)];
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        LevelData levelData;
        boolean isDayTime = world.m_46468_() % 24000L < 12000L;
        boolean isGlow = this.canGlow((Level)world, isDayTime);
        if (this.isMaxAge(state)) {
            if (!isGlow) {
                this.glowDown((Level)world, state, pos);
            }
            return;
        }
        int addChence = 0;
        if (this.data == 2 && (levelData = world.m_6106_()) instanceof ServerLevelData) {
            ServerLevelData worldInfo = (ServerLevelData)levelData;
            int n = addChence = worldInfo.m_6534_() ? -1 : 0;
        }
        if (isGlow && ForgeHooks.onCropsGrowPre((Level)world, (BlockPos)pos, (BlockState)state, (boolean)this.isGlowChange(rand, addChence))) {
            this.glowUp((Level)world, state, pos);
        }
    }

    public boolean canGlow(Level world, boolean isDayTime) {
        return isDayTime && this.data == 0 || !isDayTime && this.data == 1 || world.m_46471_() && this.data == 2;
    }

    public void glowDown(Level world, BlockState state, BlockPos pos) {
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)this.getSMMaxAge(), (Comparable)Integer.valueOf(this.getMaxBlockState() - 1)), 2);
    }

    public void glowUp(Level world, BlockState state, BlockPos pos) {
        int nowAge = this.getNowState(state);
        BlockState glowState = (BlockState)state.m_61124_((Property)this.getSMMaxAge(), (Comparable)Integer.valueOf(nowAge + 1));
        world.m_7731_(pos, glowState, 2);
        world.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)glowState));
        ForgeHooks.onCropsGrowPost((Level)world, (BlockPos)pos, (BlockState)state);
    }

    public boolean isGlowChange(RandomSource rand, int addChance) {
        return rand.m_188503_(this.getGlowChange() + addChance) == 0;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof SMSickle) {
            SMSickle sickle = (SMSickle)item;
            sickle.getPickPlant(world, player, pos, stack);
            return InteractionResult.SUCCESS;
        }
        if (!this.isMaxAge(state)) {
            return InteractionResult.SUCCESS;
        }
        this.onRicghtClick(world, player, state, pos, player.m_21120_(hand));
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    }

    @Override
    public void onRicghtClick(Level world, Player player, BlockState state, BlockPos pos, ItemStack stack) {
        RandomSource rand = world.m_213780_();
        ItemEntity drop = this.getDropItem(world, player, stack, this.getCrop(), this.getDropValue(rand, 0));
        world.m_7967_((Entity)drop);
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)this.getSMMaxAge(), (Comparable)Integer.valueOf(this.RCSetState())), 2);
        this.playCropSound(world, rand, pos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> build) {
        build.m_61104_(new Property[]{this.getSMMaxAge()});
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        boolean isDayTime;
        if (rand.m_188501_() <= 0.95f) {
            return;
        }
        boolean bl = isDayTime = world.m_46468_() % 24000L < 12000L;
        if (this.data == 0 && isDayTime || this.data == 1 && !isDayTime || world.m_46471_() && this.data == 2) {
            this.addParticlesAroundSelf(world, rand, pos, (ParticleOptions)ParticleTypes.f_123748_);
        }
    }

    protected void addParticlesAroundSelf(Level level, RandomSource rand, BlockPos pos, ParticleOptions par) {
        for (int i = 0; i < 4; ++i) {
            double xS = rand.m_188500_() * 0.02;
            double yS = rand.m_188500_() * 0.02;
            double zS = rand.m_188500_() * 0.02;
            level.m_7106_(par, this.getRandomX(pos, rand, 0.5), this.getRandomY(pos, rand), this.getRandomZ(pos, rand, 0.5), xS, yS, zS);
        }
    }

    public double getRandomX(BlockPos pos, RandomSource rand, double scale) {
        return (double)pos.m_123341_() + (rand.m_188500_() - 0.5) * scale + 0.5;
    }

    public double getRandomY(BlockPos pos, RandomSource rand) {
        return (double)pos.m_123342_() + rand.m_188500_();
    }

    public double getRandomZ(BlockPos pos, RandomSource rand, double scale) {
        return (double)pos.m_123343_() + (rand.m_188500_() - 0.5) * scale + 0.5;
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder build) {
        return this.getDropList(state, build);
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.CROP;
    }
}

