/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.crop;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeHooks;
import sweetmagic.api.iblock.ISMCrop;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.block.base.BaseFaceBlock;
import sweetmagic.init.block.base.BaseSMBlock;
import sweetmagic.init.item.sm.SMSickle;

public class SweetCrops_STAGE1
extends BaseFaceBlock
implements ISMCrop,
BonemealableBlock {
    private final int data;
    private int chance;

    public SweetCrops_STAGE1(String name, int data, int chance) {
        super(name, BaseSMBlock.setState(Material.f_76320_, SoundType.f_56736_, 1.0f, 8192.0f).m_60977_());
        this.data = data;
        this.chance = chance;
        this.m_49959_((BlockState)this.setState().m_61124_((Property)this.getSMMaxAge(), (Comparable)Integer.valueOf(0)));
        BlockInit.BlockInfo.create(this, null, name);
    }

    @Override
    public ItemLike getCrop() {
        switch (this.data) {
            default: 
        }
        return ItemInit.maple_syrup;
    }

    @Override
    public ItemLike getSeed() {
        return null;
    }

    @Override
    public int getMaxBlockState() {
        return 1;
    }

    @Override
    public IntegerProperty getSMMaxAge() {
        return ISMCrop.AGE1;
    }

    @Override
    public void setGlowChance(int chance) {
        this.chance = chance;
    }

    @Override
    public int getGlowChange() {
        return this.chance;
    }

    @Override
    public int RCSetState() {
        return 0;
    }

    @Override
    public BlockState getDefault() {
        return this.m_49966_();
    }

    @Override
    public int getDropValue(RandomSource rand, int fortune) {
        return Math.max(1, rand.m_188503_(3) + 1);
    }

    public ItemStack m_7397_(BlockGetter get, BlockPos pos, BlockState state) {
        return new ItemStack(this.getCrop());
    }

    public boolean m_6724_(BlockState state) {
        return !this.isMaxAge(state);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!this.isMaxAge(state) && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (boolean)this.isGlowChange(rand))) {
            int nowAge = this.getNowState(state);
            BlockState glowState = (BlockState)((BlockState)state.m_61124_((Property)this.getSMMaxAge(), (Comparable)Integer.valueOf(nowAge + 1))).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)));
            level.m_7731_(pos, glowState, 2);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)glowState));
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    @Override
    public void growCrops(Level world, BlockPos pos, BlockState state) {
        int age = Math.min(this.getNowState(state) + this.getBonemealAgeIncrease(world), this.getMaxBlockState());
        world.m_7731_(pos, (BlockState)this.getStateForAge(age).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))), 2);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof SMSickle) {
            SMSickle sickle = (SMSickle)item;
            sickle.getPickPlant(world, player, pos, stack);
            return InteractionResult.SUCCESS;
        }
        if (!this.isMaxAge(state)) {
            return InteractionResult.PASS;
        }
        this.onRicghtClick(world, player, state, pos, stack);
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    }

    @Override
    public void onRicghtClick(Level world, Player player, BlockState state, BlockPos pos, ItemStack stack) {
        RandomSource rand = world.m_213780_();
        ItemEntity drop = this.getDropItem(world, player, stack, this.getCrop(), this.getDropValue(rand, 0));
        world.m_7967_((Entity)drop);
        world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)this.getSMMaxAge(), (Comparable)Integer.valueOf(this.RCSetState()))).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))), 2);
        world.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.5f, 0.8f + rand.m_188501_() * 0.4f);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> bui) {
        bui.m_61104_(new Property[]{this.getSMMaxAge(), FACING});
    }

    public boolean m_7370_(BlockGetter get, BlockPos pos, BlockState state, boolean falg) {
        return false;
    }

    public boolean m_214167_(Level world, RandomSource rand, BlockPos pos, BlockState state) {
        return false;
    }

    public void m_214148_(ServerLevel world, RandomSource rand, BlockPos pos, BlockState state) {
        this.growCrops((Level)world, pos, state);
    }

    @Override
    public int getBonemealAgeIncrease(Level world) {
        return Mth.m_216271_((RandomSource)world.m_213780_(), (int)0, (int)1);
    }

    @Override
    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder build) {
        List stackList = this.getDropList(state, build);
        if (((ItemStack)build.m_78982_(LootContextParams.f_81463_)).m_41720_() instanceof AxeItem) {
            stackList.add(new ItemStack((ItemLike)BlockInit.maple_hole_log));
        } else if (!this.isMaxAge(state)) {
            stackList.add(new ItemStack((ItemLike)BlockInit.maple_log));
        }
        return stackList;
    }
}

