/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.crop;

import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.PlantType;
import sweetmagic.api.iblock.ISMCrop;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.block.base.BaseSMBlock;
import sweetmagic.init.item.sm.SMSickle;

public class SweetCrops_STAGE2
extends BushBlock
implements ISMCrop,
BonemealableBlock {
    private final int data;
    private int chance;
    private static final VoxelShape[] CROP_VEXE = new VoxelShape[]{Block.m_49796_((double)3.2, (double)6.4, (double)3.2, (double)12.8, (double)16.0, (double)12.8), Block.m_49796_((double)1.6, (double)3.2, (double)1.6, (double)14.4, (double)16.0, (double)14.4), Block.m_49796_((double)0.8, (double)1.6, (double)0.8, (double)15.2, (double)16.0, (double)15.2)};

    public SweetCrops_STAGE2(String name, int data, int chance) {
        super(BaseSMBlock.setState(Material.f_76300_, SoundType.f_56740_, 0.0f, 8192.0f).m_60910_().m_60977_());
        this.data = data;
        this.chance = chance;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.getSMMaxAge(), (Comparable)Integer.valueOf(0)));
        BlockInit.BlockInfo.create((Block)this, null, name);
    }

    @Override
    public ItemLike getCrop() {
        return switch (this.data) {
            case 1 -> ItemInit.coconut;
            case 2 -> ItemInit.banana;
            default -> ItemInit.chestnut;
        };
    }

    @Override
    public ItemLike getSeed() {
        return null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext con) {
        return CROP_VEXE[this.getNowState(state)];
    }

    @Override
    public int getMaxBlockState() {
        return 2;
    }

    @Override
    public IntegerProperty getSMMaxAge() {
        return ISMCrop.AGE2;
    }

    @Override
    public void setGlowChance(int chance) {
        this.chance = chance;
    }

    @Override
    public int getGlowChange() {
        return this.chance;
    }

    @Override
    public int RCSetState() {
        return 0;
    }

    @Override
    public BlockState getDefault() {
        return this.m_49966_();
    }

    @Override
    public int getDropValue(RandomSource rand, int fortune) {
        return Math.max(1, rand.m_188503_(4) + 1);
    }

    public ItemStack m_7397_(BlockGetter get, BlockPos pos, BlockState state) {
        return new ItemStack(this.getCrop());
    }

    public boolean m_6724_(BlockState state) {
        return !this.isMaxAge(state);
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (!this.isMaxAge(state) && ForgeHooks.onCropsGrowPre((Level)world, (BlockPos)pos, (BlockState)state, (boolean)this.isGlowChange(rand))) {
            BlockState glowState = (BlockState)state.m_61124_((Property)this.getSMMaxAge(), (Comparable)Integer.valueOf(this.getNowState(state) + 1));
            world.m_7731_(pos, glowState, 2);
            world.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)glowState));
            ForgeHooks.onCropsGrowPost((Level)world, (BlockPos)pos, (BlockState)state);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof SMSickle) {
            SMSickle sickle = (SMSickle)item;
            sickle.getPickPlant(world, player, pos, stack);
            return InteractionResult.SUCCESS;
        }
        if (!this.isMaxAge(state)) {
            return stack.m_150930_(Items.f_42499_) ? InteractionResult.PASS : InteractionResult.SUCCESS;
        }
        this.onRicghtClick(world, player, state, pos, stack);
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    }

    @Override
    public void onRicghtClick(Level world, Player player, BlockState state, BlockPos pos, ItemStack stack) {
        RandomSource rand = world.m_213780_();
        ItemEntity drop = this.getDropItem(world, player, stack, this.getCrop(), this.getDropValue(rand, 0));
        world.m_7967_((Entity)drop);
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)this.getSMMaxAge(), (Comparable)Integer.valueOf(this.RCSetState())), 2);
        this.playCropSound(world, rand, pos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> def) {
        def.m_61104_(new Property[]{this.getSMMaxAge()});
    }

    public boolean m_7370_(BlockGetter get, BlockPos pos, BlockState state, boolean falg) {
        return !this.isMaxAge(state);
    }

    public boolean m_214167_(Level world, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel world, RandomSource rand, BlockPos pos, BlockState state) {
        this.growCrops((Level)world, pos, state);
    }

    @Override
    public int getBonemealAgeIncrease(Level level) {
        return Mth.m_216271_((RandomSource)level.m_213780_(), (int)0, (int)1);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder build) {
        ItemStack stack = (ItemStack)build.m_78982_(LootContextParams.f_81463_);
        if (stack.m_41720_() instanceof ShearsItem) {
            return Arrays.asList(new ItemStack((ItemLike)this));
        }
        return this.getDropList(state, build);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos underpos = pos.m_7494_();
        return this.m_6266_(world.m_8055_(underpos), (BlockGetter)world, underpos);
    }

    protected boolean m_6266_(BlockState state, BlockGetter get, BlockPos pos) {
        return state.m_204336_(BlockTags.f_13035_);
    }

    public PlantType getPlantType(BlockGetter get, BlockPos pos) {
        return PlantType.CROP;
    }
}

