/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.crop;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.PlantType;
import sweetmagic.api.iblock.ISMCrop;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.block.base.BaseSMBlock;
import sweetmagic.init.item.sm.SMSickle;

public class SweetCrops_STAGE5
extends BushBlock
implements ISMCrop,
BonemealableBlock {
    private final int data;
    private int chance;
    private final boolean isFarm;
    private static final VoxelShape[] CROP_VEXE = new VoxelShape[]{Block.m_49796_((double)1.6, (double)0.0, (double)1.6, (double)14.4, (double)1.0, (double)14.4), Block.m_49796_((double)1.6, (double)0.0, (double)1.6, (double)14.4, (double)5.0, (double)14.4), Block.m_49796_((double)1.6, (double)0.0, (double)1.6, (double)14.4, (double)7.0, (double)14.4), Block.m_49796_((double)1.6, (double)0.0, (double)1.6, (double)14.4, (double)10.0, (double)14.4), Block.m_49796_((double)1.6, (double)0.0, (double)1.6, (double)14.4, (double)10.0, (double)14.4), Block.m_49796_((double)1.6, (double)0.0, (double)1.6, (double)14.4, (double)10.0, (double)14.4)};

    public SweetCrops_STAGE5(String name, int data, int chance, boolean isFarm) {
        super(BaseSMBlock.setState(Material.f_76300_, SoundType.f_56740_, 0.0f, 8192.0f).m_60910_().m_60977_());
        this.data = data;
        this.chance = chance;
        this.isFarm = isFarm;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.getSMMaxAge(), (Comparable)Integer.valueOf(0)));
        BlockInit.BlockInfo.create((Block)this, null, name);
    }

    @Override
    public ItemLike getCrop() {
        return switch (this.data) {
            case 1 -> ItemInit.raspberry;
            case 2 -> ItemInit.soybean;
            case 3 -> ItemInit.rice_plants;
            case 4 -> ItemInit.azuki_seed;
            case 5 -> Items.f_42534_;
            case 6 -> Items.f_42451_;
            case 7 -> Items.f_42749_;
            case 8 -> Items.f_42587_;
            default -> Items.f_42692_;
        };
    }

    @Override
    public ItemLike getSeed() {
        return switch (this.data) {
            case 1 -> ItemInit.raspberry;
            case 2 -> ItemInit.soybean;
            case 3 -> ItemInit.rice_seed;
            case 4 -> ItemInit.azuki_seed;
            case 5 -> ItemInit.lapislazuli_seed;
            case 6 -> ItemInit.redstone_seed;
            case 7 -> ItemInit.iron_seed;
            case 8 -> ItemInit.gold_seed;
            default -> ItemInit.quartz_seed;
        };
    }

    @Override
    public int getMaxBlockState() {
        return 5;
    }

    @Override
    public IntegerProperty getSMMaxAge() {
        return ISMCrop.AGE5;
    }

    @Override
    public void setGlowChance(int chance) {
        this.chance = chance;
    }

    @Override
    public int getGlowChange() {
        return this.chance;
    }

    @Override
    public int RCSetState() {
        return 2;
    }

    @Override
    public BlockState getDefault() {
        return this.m_49966_();
    }

    @Override
    public int getDropValue(RandomSource rand, int fortune) {
        return Math.max(1, rand.m_188503_(3) + 1);
    }

    public ItemStack m_7397_(BlockGetter get, BlockPos pos, BlockState state) {
        return new ItemStack(this.getCrop());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext con) {
        return CROP_VEXE[this.getNowState(state)];
    }

    public boolean m_6724_(BlockState state) {
        return !this.isMaxAge(state);
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (!this.isMaxAge(state) && ForgeHooks.onCropsGrowPre((Level)world, (BlockPos)pos, (BlockState)state, (boolean)this.isGlowChange(rand))) {
            BlockState glowState = (BlockState)state.m_61124_((Property)this.getSMMaxAge(), (Comparable)Integer.valueOf(this.getNowState(state) + 1));
            world.m_7731_(pos, glowState, 2);
            world.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)glowState));
            ForgeHooks.onCropsGrowPost((Level)world, (BlockPos)pos, (BlockState)state);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof SMSickle) {
            SMSickle sickle = (SMSickle)item;
            sickle.getPickPlant(world, player, pos, stack);
            return InteractionResult.SUCCESS;
        }
        if (!this.isMaxAge(state)) {
            if (stack.m_150930_(Items.f_42499_)) {
                return InteractionResult.PASS;
            }
            if (this.data == 2 && this.getNowState(state) >= this.getMaxBlockState() - 1) {
                RandomSource rand = world.m_213780_();
                ItemEntity drop = this.getDropItem(world, player, stack, (ItemLike)ItemInit.edamame, this.getDropValue(rand, 0));
                world.m_7967_((Entity)drop);
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)this.getSMMaxAge(), (Comparable)Integer.valueOf(this.RCSetState())), 2);
                this.playCropSound(world, rand, pos);
            }
            return InteractionResult.SUCCESS;
        }
        this.onRicghtClick(world, player, state, pos, stack);
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    }

    @Override
    public void onRicghtClick(Level world, Player player, BlockState state, BlockPos pos, ItemStack stack) {
        RandomSource rand = world.m_213780_();
        ItemEntity drop = this.getDropItem(world, player, stack, this.getCrop(), this.getDropValue(rand, 0));
        world.m_7967_((Entity)drop);
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)this.getSMMaxAge(), (Comparable)Integer.valueOf(this.RCSetState())), 2);
        this.playCropSound(world, rand, pos);
    }

    @Override
    public List<ItemStack> rightClickStack(Level world, BlockState state, BlockPos pos) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        stackList.add(this.getDropStack(world.m_213780_()));
        if (this.data == 2) {
            stackList.add(new ItemStack((ItemLike)ItemInit.edamame, this.getDropValue(world.m_213780_(), 0)));
        }
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)this.getSMMaxAge(), (Comparable)Integer.valueOf(this.RCSetState())), 2);
        return stackList;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> def) {
        def.m_61104_(new Property[]{this.getSMMaxAge()});
    }

    public boolean m_7370_(BlockGetter get, BlockPos pos, BlockState state, boolean falg) {
        return !this.isMaxAge(state);
    }

    public boolean m_214167_(Level world, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel world, RandomSource rand, BlockPos pos, BlockState state) {
        this.growCrops((Level)world, pos, state);
    }

    @Override
    public void growCrops(Level world, BlockPos pos, BlockState state) {
        if ((this.data == 7 || this.data == 8) && world.m_213780_().m_188501_() > 0.2f) {
            return;
        }
        int age = Math.min(this.getNowState(state) + this.getBonemealAgeIncrease(world), this.getMaxBlockState());
        world.m_7731_(pos, this.getStateForAge(age), 2);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder build) {
        return this.getDropList(state, build);
    }

    @Override
    public List<ItemStack> getDropList(BlockState state, LootContext.Builder build) {
        ArrayList stackList = Lists.newArrayList();
        RandomSource rand = build.m_78962_().m_213780_();
        if (this.isMaxAge(state)) {
            ItemStack stack;
            Player player;
            int level;
            stackList.add(new ItemStack(this.getCrop(), rand.m_188503_(this.getMaxBlockState()) + 1));
            if (this.getSeed() != this.getCrop()) {
                stackList.add(new ItemStack(this.getSeed(), rand.m_188503_(2)));
            }
            if (this.data == 2 && (level = this.getLuck(player = (Player)build.m_78982_(LootContextParams.f_81456_), stack = (ItemStack)build.m_78982_(LootContextParams.f_81463_))) >= 0) {
                stackList.add(new ItemStack((ItemLike)ItemInit.edamame, rand.m_188503_(this.getMaxBlockState()) + 1 + level));
            }
        } else if (this.data == 2 && this.getNowState(state) == 4) {
            stackList.add(new ItemStack((ItemLike)ItemInit.edamame, rand.m_188503_(this.getMaxBlockState()) + 1));
        }
        stackList.add(new ItemStack(this.getSeed()));
        return stackList;
    }

    public int getLuck(Player player, ItemStack stack) {
        int level;
        int n = level = stack.m_41619_() ? 0 : stack.getEnchantmentLevel(Enchantments.f_44987_);
        if (player != null && player.m_21023_(MobEffects.f_19621_)) {
            level += player.m_21124_(MobEffects.f_19621_).m_19564_();
        }
        return level;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos underpos = pos.m_7495_();
        return this.m_6266_(world.m_8055_(underpos), (BlockGetter)world, underpos);
    }

    protected boolean m_6266_(BlockState state, BlockGetter get, BlockPos pos) {
        return this.checkPlace(state, get, pos);
    }

    @Override
    public boolean isOnlyFarm() {
        return this.isFarm;
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.CROP;
    }
}

