/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.magic;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.base.BaseMFBlock;
import sweetmagic.init.tile.sm.TileMFPot;

public class MFPot
extends BaseMFBlock {
    public final int data;
    public final int tier;
    private static final VoxelShape AABB = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)11.0, (double)10.0);

    public MFPot(String name, int data, int tier) {
        super(name);
        this.data = data;
        this.tier = tier;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext con) {
        return AABB;
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        if (world.m_5776_()) {
            return false;
        }
        TileMFPot tile = (TileMFPot)this.getTile(world, pos);
        if (this.data == 3 && player.f_36079_ >= 500 && !tile.isMaxMF()) {
            int oldEXP = player.f_36079_;
            player.m_6756_(-500);
            int newEXP = player.f_36079_;
            int difEXP = oldEXP - newEXP;
            tile.setMF(tile.getMF() + difEXP * 8);
            tile.sendPKT();
            this.playerSound(world, pos, SoundEvents.f_12019_, 0.5f, 1.0f);
        } else {
            player.m_213846_((Component)this.getLabel(this.format(tile.getMF()) + "MF", GREEN));
        }
        return true;
    }

    public int getData() {
        return this.data;
    }

    @Override
    public int getMaxMF() {
        return 200000;
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileMFPot(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return this.createMailBoxTicker(world, type, TileInit.mfpot);
    }
}

