/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.magic;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.base.BaseMFBlock;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileMFTable;
import sweetmagic.init.tile.sm.TileMFTableAdvanced;
import sweetmagic.init.tile.sm.TileMFTableMaster;

public class MFTable
extends BaseMFBlock {
    private final int data;

    public MFTable(String name, int data) {
        super(name);
        this.data = data;
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        if (world.m_5776_()) {
            return false;
        }
        this.openGUI(world, pos, player, this.getTile(world, pos));
        return true;
    }

    @Override
    public int getMaxMF() {
        return switch (this.data) {
            case 1 -> 400000;
            case 2 -> 8000000;
            default -> 20000;
        };
    }

    @Override
    public int getTier() {
        return this.data + 1;
    }

    @Override
    public boolean keepTileInfo() {
        return true;
    }

    @Override
    public ItemStack inheritingNBT(ItemStack oldStack, ItemStack newStack) {
        if (oldStack.m_41784_().m_128441_("BlockEntityTag")) {
            CompoundTag tags = oldStack.m_41737_("BlockEntityTag");
            int oldSlotSize = this.data == 0 ? 1 : 4;
            ItemStackHandler oldInputInv = new ItemStackHandler(oldSlotSize);
            oldInputInv.deserializeNBT(tags.m_128469_("wandInv"));
            int newSlotSize = this.data == 0 ? 4 : 6;
            ItemStackHandler newInputInv = new ItemStackHandler(newSlotSize);
            for (int i = 0; i < oldSlotSize; ++i) {
                newInputInv.setStackInSlot(i, oldInputInv.getStackInSlot(i));
            }
            tags.m_128473_("wandInv");
            tags.m_128365_("wandInv", (Tag)newInputInv.serializeNBT());
            CompoundTag newTags = new CompoundTag();
            newTags.m_128365_("BlockEntityTag", (Tag)tags);
            newTags.m_128405_("mf", oldStack.m_41783_().m_128451_("mf"));
            newStack.m_41751_(newTags);
        }
        return newStack;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return switch (this.data) {
            case 1 -> new TileMFTableAdvanced(pos, state);
            case 2 -> new TileMFTableMaster(pos, state);
            default -> new TileMFTable(pos, state);
        };
    }

    @Override
    public BlockEntityType<? extends TileAbstractSM> getTileType() {
        return switch (this.data) {
            case 1 -> TileInit.tableAdavance;
            case 2 -> TileInit.tableMaster;
            default -> TileInit.table;
        };
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return this.createMailBoxTicker(world, type, this.getTileType());
    }

    @Override
    public void addTip(List<Component> toolTip, ItemStack stack, CompoundTag tags) {
        toolTip.add((Component)this.getTipArray(new Object[]{this.getText("mftable"), GREEN}));
    }
}

