/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.magic;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.base.BaseMFBlock;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileMFTank;
import sweetmagic.init.tile.sm.TileMFTankAdavance;
import sweetmagic.init.tile.sm.TileMFTankCreative;
import sweetmagic.init.tile.sm.TileMFTankMaster;

public class MFTank
extends BaseMFBlock {
    public final int data;

    public MFTank(String name, int data) {
        super(name);
        this.data = data;
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        BlockItem item;
        Item item2;
        if (world.m_5776_()) {
            return true;
        }
        if (!stack.m_41619_() && (item2 = stack.m_41720_()) instanceof BlockItem && (item2 = (item = (BlockItem)item2).m_40614_()) instanceof MFTank) {
            MFTank tank = (MFTank)item2;
            if (world.m_46859_(pos.m_7494_())) {
                world.m_7731_(pos.m_7494_(), tank.m_49966_(), 3);
                this.blockSound(world, tank, pos, player);
                return true;
            }
        }
        this.openGUI(world, pos, player, this.getTile(world, pos));
        return true;
    }

    @Override
    public int getTier() {
        return this.data + 1;
    }

    @Override
    public int getMaxMF() {
        return switch (this.data) {
            case 1 -> 1000000;
            case 2 -> 10000000;
            case 3 -> Integer.MAX_VALUE;
            default -> 100000;
        };
    }

    @Override
    public boolean keepTileInfo() {
        return true;
    }

    @Override
    public ItemStack inheritingNBT(ItemStack oldStack, ItemStack newStack) {
        if (oldStack.m_41784_().m_128441_("BlockEntityTag")) {
            CompoundTag tags = oldStack.m_41737_("BlockEntityTag");
            int oldInputSize = this.data == 0 ? 1 : 3;
            ItemStackHandler oldInputInv = new ItemStackHandler(oldInputSize);
            oldInputInv.deserializeNBT(tags.m_128469_("inputInv"));
            int newInputSize = this.data == 0 ? 3 : 5;
            ItemStackHandler newInputInv = new ItemStackHandler(newInputSize);
            for (int i = 0; i < oldInputSize; ++i) {
                newInputInv.setStackInSlot(i, oldInputInv.getStackInSlot(i));
            }
            tags.m_128473_("inputInv");
            tags.m_128365_("inputInv", (Tag)newInputInv.serializeNBT());
            int oldOutSize = this.data == 0 ? 3 : 5;
            ItemStackHandler oldOutInv = new ItemStackHandler(oldOutSize);
            oldOutInv.deserializeNBT(tags.m_128469_("outputInv"));
            int newOutSize = this.data == 0 ? 5 : 10;
            ItemStackHandler newOutInv = new ItemStackHandler(newOutSize);
            for (int i = 0; i < oldOutSize; ++i) {
                newOutInv.setStackInSlot(i, oldOutInv.getStackInSlot(i));
            }
            tags.m_128473_("outputInv");
            tags.m_128365_("outputInv", (Tag)newOutInv.serializeNBT());
            CompoundTag newTags = new CompoundTag();
            newTags.m_128365_("BlockEntityTag", (Tag)tags);
            newTags.m_128405_("mf", oldStack.m_41783_().m_128451_("mf"));
            newStack.m_41751_(newTags);
        }
        return newStack;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return switch (this.data) {
            case 1 -> new TileMFTankAdavance(pos, state);
            case 2 -> new TileMFTankMaster(pos, state);
            case 3 -> new TileMFTankCreative(pos, state);
            default -> new TileMFTank(pos, state);
        };
    }

    @Override
    public BlockEntityType<? extends TileAbstractSM> getTileType() {
        return switch (this.data) {
            case 1 -> TileInit.tankAdavance;
            case 2 -> TileInit.tankMaster;
            case 3 -> TileInit.tankCreative;
            default -> TileInit.tank;
        };
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return this.createMailBoxTicker(world, type, this.getTileType());
    }

    @Override
    public void addTip(List<Component> toolTip, ItemStack stack, CompoundTag tags) {
        toolTip.add((Component)this.getTipArray(new Object[]{this.getText("mftank"), GREEN}));
        toolTip.add((Component)this.getTipArray(new Object[]{this.getText("mftank_pili"), GOLD}));
    }
}

