/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.magic;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.iblock.IWaterBlock;
import sweetmagic.api.util.ISMTip;
import sweetmagic.event.HasItemEvent;
import sweetmagic.init.BlockInit;
import sweetmagic.init.block.base.BaseSMBlock;

public class MagicLight
extends BaseSMBlock
implements IWaterBlock,
ISMTip {
    private static final VoxelShape LIGHT = Block.m_49796_((double)3.2, (double)3.2, (double)3.2, (double)12.8, (double)12.8, (double)12.8);
    public final int data;
    private final float enchaPower;

    public MagicLight(String name, int data) {
        super(name, MagicLight.setState(Material.f_76275_, SoundType.f_56742_, 0.0f, 8192.0f, 15).m_60910_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.data = data;
        BlockInit.BlockInfo.create(this, this.data == 0 ? null : SweetMagicCore.smMagicTab, name);
        this.enchaPower = data == 1 ? 3.75f : 0.0f;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext col) {
        try {
            return this.data == 1 || HasItemEvent.hasThisItem ? LIGHT : Shapes.m_83040_();
        }
        catch (RuntimeException runtimeException) {
            return Shapes.m_83040_();
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext con) {
        BlockPos pos = con.m_8083_();
        BlockState state = con.m_43725_().m_8055_(pos);
        if (state.m_60713_((Block)this)) {
            return (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        FluidState fluid = con.m_43725_().m_6425_(pos);
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> build) {
        build.m_61104_(new Property[]{WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction face, BlockState newState, LevelAccessor world, BlockPos pos1, BlockPos pos2) {
        this.setWater(world, state, pos1);
        return super.m_7417_(state, face, newState, world, pos1, pos2);
    }

    public boolean m_7357_(BlockState state, BlockGetter get, BlockPos pos, PathComputationType type) {
        return type == PathComputationType.WATER ? get.m_6425_(pos).m_205070_(FluidTags.f_13131_) : false;
    }

    @Override
    public float getEnchantPower() {
        return this.enchaPower;
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        if (this.data == 0) {
            return;
        }
        toolTip.add((Component)this.tierTip(1));
        toolTip.add((Component)this.getText(this.name).m_130940_(GREEN));
        super.addBlockTip(toolTip);
    }
}

