/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.magic;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.BlockInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.base.BaseFaceBlock;
import sweetmagic.init.block.base.BaseSMBlock;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileObMagia;
import sweetmagic.init.tile.sm.TileStove;

public class ObMagia
extends BaseFaceBlock
implements EntityBlock {
    private final boolean isTop;
    private static final VoxelShape BOT = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape TOP = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);

    public ObMagia(String name, boolean isTop) {
        super(name, ObMagia.setState(Material.f_76283_, SoundType.f_56743_, 1.0f, 8192.0f));
        this.isTop = isTop;
        this.m_49959_(this.setState());
        BlockInit.BlockInfo.create(this, isTop ? null : SweetMagicCore.smMagicTab, name);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext col) {
        return this.isTop ? TOP : BOT;
    }

    @Override
    public boolean canRightClick(Player player, ItemStack stack) {
        return true;
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        if (world.m_5776_()) {
            return true;
        }
        pos = this.isTop ? pos.m_7495_() : pos;
        TileAbstractSM tile = this.getTile(world, pos);
        if (tile != null) {
            this.openGUI(world, pos, player, tile);
        } else {
            Block block = this.getBlock(world, pos);
            if (block instanceof BaseSMBlock) {
                BaseSMBlock sm = (BaseSMBlock)block;
                sm.actionBlock(world, pos, player, stack);
            }
        }
        return true;
    }

    @Override
    public boolean isKeepTile() {
        return !this.isTop;
    }

    @Override
    public void onRemove(Level world, BlockPos pos, BlockState state, TileAbstractSM tile) {
        if (!this.isKeepTile()) {
            return;
        }
        if (tile instanceof TileObMagia) {
            TileObMagia magia = (TileObMagia)tile;
            magia.craftList.forEach(s -> this.spawnItem(world, pos, (ItemStack)s));
            magia.clearInfo();
        }
        this.spawnItem(world, pos, tile.getDropStack(new ItemStack((ItemLike)this)));
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return world.m_46859_(pos.m_7494_());
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        world.m_46597_(pos.m_7494_(), (BlockState)BlockInit.obmagia_top.m_49966_().m_61124_((Property)FACING, (Comparable)placer.m_6350_()));
    }

    public ItemStack m_7397_(BlockGetter get, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)BlockInit.obmagia);
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos targetPos = this.isTop ? pos.m_7495_() : pos.m_7494_();
        BlockState upState = world.m_8055_(targetPos);
        if (upState.m_60734_() instanceof ObMagia) {
            world.m_7731_(targetPos, Blocks.f_50016_.m_49966_(), 35);
            world.m_5898_(player, 2001, targetPos, Block.m_49956_((BlockState)upState));
        }
        super.m_5707_(world, pos, state, player);
    }

    @Override
    protected boolean isDrop() {
        return false;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.isTop ? new TileStove(pos, state) : new TileObMagia(pos, state);
    }

    @Override
    public BlockEntityType<? extends TileAbstractSM> getTileType() {
        return this.isTop ? null : TileInit.obmagia;
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return this.isTop ? null : this.createMailBoxTicker(level, type, TileInit.obmagia);
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        if (!this.isTop) {
            toolTip.add((Component)this.tierTip(1));
            toolTip.add((Component)this.getText(this.name).m_130940_(GREEN));
        }
    }
}

