/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.magic;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import sweetmagic.api.iblock.ISMCraftBlock;
import sweetmagic.api.iitem.IPorch;
import sweetmagic.init.ItemInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.base.BaseMFBlock;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileAltarCreat;
import sweetmagic.init.tile.sm.TileAltarCreatStar;
import sweetmagic.init.tile.sm.TilePedalCreate;
import sweetmagic.recipe.RecipeHelper;
import sweetmagic.recipe.base.AbstractRecipe;
import sweetmagic.recipe.pedal.PedalRecipe;

public class PedalCreate
extends BaseMFBlock
implements ISMCraftBlock {
    public int data;
    private static final VoxelShape AABB = Block.m_49796_((double)1.2, (double)0.0, (double)1.2, (double)14.8, (double)11.2, (double)14.8);
    private static final VoxelShape ALTAR = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.8, (double)16.0);
    private static final VoxelShape STAR = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)20.0, (double)16.0);

    public PedalCreate(String name, int data) {
        super(name);
        this.data = data;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext col) {
        return switch (this.data) {
            case 1 -> ALTAR;
            case 2 -> STAR;
            default -> AABB;
        };
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        if (world.m_5776_()) {
            return true;
        }
        this.pedalCraft(world, pos, player, stack, false);
        return true;
    }

    public void pedalCraft(Level world, BlockPos pos, Player player, ItemStack stack, boolean isSneak) {
        TilePedalCreate tile = (TilePedalCreate)this.getTile(world, pos);
        if (tile.isCraft) {
            return;
        }
        if (stack.m_41619_()) {
            player.m_213846_((Component)this.getLabel(this.format(tile.getMF()) + "MF", GREEN));
        } else if (tile.resultList.isEmpty()) {
            MutableComponent tip;
            List<ItemStack> stackList = RecipeHelper.getPlayerInv(player, stack);
            MutableComponent mutableComponent = tip = isSneak ? tile.checkCanAllCraft(stackList) : tile.checkCanCraft(stackList);
            if (tip == null) {
                ItemStack leg = player.m_6844_(EquipmentSlot.LEGS);
                Item item = leg.m_41720_();
                if (item instanceof IPorch) {
                    IPorch porch = (IPorch)item;
                    tile.quickCraft = porch.hasAcce(leg, ItemInit.witch_scroll);
                }
                tile.craftStart();
            } else {
                player.m_213846_((Component)tip);
            }
        }
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TilePedalCreate tile = (TilePedalCreate)this.getTile(TilePedalCreate::new, world, pos);
        tile.isHaveBlock = tile.checkBlock();
        tile.sendPKT();
        if (tile.isHaveBlock) {
            this.haveBlock(world, pos);
        }
    }

    public void haveBlock(Level world, BlockPos pos) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel sever = (ServerLevel)world;
        float posX = (float)pos.m_123341_() + 0.5f;
        float posY = (float)pos.m_123342_() - 0.5f;
        float posZ = (float)pos.m_123343_() + 0.5f;
        RandomSource rand = world.m_213780_();
        for (int k = 0; k < 12; ++k) {
            float f1 = posX - 0.75f + rand.m_188501_() * 1.5f;
            float f2 = posY + 0.5f + rand.m_188501_() * 0.5f;
            float f3 = posZ - 0.75f + rand.m_188501_() * 1.5f;
            sever.m_8767_((ParticleOptions)ParticleInit.TWILIGHTLIGHT, (double)f1, (double)f2, (double)f3, 2, 0.0, 0.0, 0.0, (double)0.01f);
        }
    }

    @Override
    public int getMaxMF() {
        return switch (this.data) {
            case 1 -> 200000;
            case 2 -> 2000000;
            default -> 20000;
        };
    }

    @Override
    public int getTier() {
        return this.data + 1;
    }

    @Override
    public void onRemove(Level world, BlockPos pos, BlockState state, TileAbstractSM base) {
        if (base instanceof TilePedalCreate) {
            TilePedalCreate tile = (TilePedalCreate)base;
            if (!tile.craftList.isEmpty()) {
                this.spawnItemList(world, pos, tile.getDropList());
                tile.clearInfo();
            }
        }
        super.onRemove(world, pos, state, base);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return switch (this.data) {
            case 1 -> new TileAltarCreat(pos, state);
            case 2 -> new TileAltarCreatStar(pos, state);
            default -> new TilePedalCreate(pos, state);
        };
    }

    @Override
    public BlockEntityType<? extends TileAbstractSM> getTileType() {
        return switch (this.data) {
            case 1 -> TileInit.altarCreat;
            case 2 -> TileInit.altarCreatStar;
            default -> TileInit.pedal;
        };
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return this.createMailBoxTicker(world, type, this.getTileType());
    }

    @Override
    public void addTip(List<Component> toolTip, ItemStack stack, CompoundTag tags) {
        toolTip.add((Component)this.getTipArray(new Object[]{this.getText("pedestal_creat"), GREEN}));
        toolTip.add((Component)this.getTipArray(new Object[]{this.getText("pedestal_creat_allcraft"), GREEN}));
    }

    @Override
    public boolean notNullRecipe(Level world, List<ItemStack> stackList) {
        return !PedalRecipe.getRecipe(world, stackList).isEmpty();
    }

    @Override
    public AbstractRecipe getRecipe(Level world, List<ItemStack> stackList) {
        return PedalRecipe.getRecipe(world, stackList).get();
    }

    @Override
    public boolean canShiftCraft() {
        return true;
    }
}

