/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.magic;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.BlockInit;
import sweetmagic.init.block.base.BaseFaceBlock;

public class RuneCharacter
extends BaseFaceBlock {
    public static final IntegerProperty SIZE = IntegerProperty.m_61631_((String)"size", (int)0, (int)7);
    private static final VoxelShape AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)0.1, (double)15.0);

    public RuneCharacter(String name) {
        super(name, RuneCharacter.setState(Material.f_76317_, SoundType.f_56746_, 0.5f, 8192.0f));
        this.m_49959_((BlockState)this.setState().m_61124_((Property)SIZE, (Comparable)Integer.valueOf(0)));
        BlockInit.BlockInfo.create(this, SweetMagicCore.smMagicTab, name);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext con) {
        return AABB;
    }

    @Override
    public boolean canRightClick(Player player, ItemStack stack) {
        return true;
    }

    @Override
    public InteractionResult onUse(Level world, BlockPos pos, Player player, InteractionHand hand) {
        if (player == null || !player.m_21205_().m_41619_()) {
            return InteractionResult.PASS;
        }
        BlockState state = world.m_8055_(pos);
        int size = (Integer)state.m_61143_((Property)SIZE) + 1;
        if (size > 7) {
            size = 0;
        }
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)SIZE, (Comparable)Integer.valueOf(size)), 3);
        this.playerSound(world, pos, SoundEvents.f_12334_, 0.25f, world.m_213780_().m_188501_() * 0.1f + 1.2f);
        return super.onUse(world, pos, player, hand);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext con) {
        return (BlockState)super.m_5573_(con).m_61124_((Property)SIZE, (Comparable)Integer.valueOf(con.m_43725_().m_213780_().m_188503_(8)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> build) {
        build.m_61104_(new Property[]{FACING, SIZE});
    }
}

