/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.magic;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import org.jetbrains.annotations.NotNull;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.BlockInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.base.BaseFaceBlock;
import sweetmagic.init.block.sm.MagiaPortal;
import sweetmagic.init.tile.sm.TileStove;
import sweetmagic.init.tile.sm.TileSturdustCrystal;
import sweetmagic.util.WorldHelper;

public class SturdustCrystal
extends BaseFaceBlock
implements EntityBlock {
    public static final BooleanProperty ISTOP = BooleanProperty.m_61465_((String)"is_top");

    public SturdustCrystal(String name) {
        super(name, SturdustCrystal.setState(Material.f_76275_, SoundType.f_56744_, 0.5f, 8192.0f).m_60910_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ISTOP, (Comparable)Boolean.valueOf(false)));
        BlockInit.BlockInfo.create(this, SweetMagicCore.smMagicTab, name);
    }

    @Override
    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public boolean canRightClick(Player player, ItemStack stack) {
        return true;
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        if (world.m_5776_()) {
            return true;
        }
        if (pos.m_123342_() <= world.m_141937_() + 1) {
            return false;
        }
        if (((Boolean)world.m_8055_(pos).m_61143_((Property)ISTOP)).booleanValue()) {
            pos = pos.m_7495_();
        }
        TileSturdustCrystal tile = (TileSturdustCrystal)this.getTile(world, pos);
        if (!tile.isRender) {
            tile.isRender = true;
            tile.sendPKT();
            player.m_213846_((Component)this.getText("place_gate").m_130940_(GREEN));
            player.m_213846_((Component)this.getText("break_gate").m_130940_(RED));
            return false;
        }
        Direction face = (Direction)world.m_8055_(pos).m_61143_((Property)FACING);
        boolean isZ = face == Direction.NORTH || face == Direction.SOUTH;
        ArrayList<ItemStack> dropList = new ArrayList<ItemStack>();
        for (int addX = -3; addX < 3; ++addX) {
            for (int addY = -1; addY < 5; ++addY) {
                for (int addZ = -2; addZ < 3; ++addZ) {
                    BlockPos targetPos = isZ ? WorldHelper.offset(pos, addX, addY, addZ) : WorldHelper.offset(pos, addZ, addY, addX);
                    BlockState state = world.m_8055_(targetPos);
                    Block block = state.m_60734_();
                    if (block == BlockInit.sturdust_crystal) continue;
                    if (block.m_155943_() >= 0.0f && world instanceof ServerLevel) {
                        ServerLevel server = (ServerLevel)world;
                        dropList.addAll(Block.m_49874_((BlockState)state, (ServerLevel)server, (BlockPos)targetPos, (BlockEntity)world.m_7702_(targetPos), (Entity)player, (ItemStack)new ItemStack((ItemLike)Items.f_42390_)));
                    }
                    this.breakBlock((LevelAccessor)world, targetPos);
                }
            }
        }
        if (!dropList.isEmpty()) {
            this.spawnItemList(world, player.m_20183_(), dropList);
        }
        Map<BlockPos, BlockState> posMap = isZ ? SturdustCrystal.getZPosMap(pos) : SturdustCrystal.getXPosMap(pos);
        posMap.forEach((p, s) -> world.m_7731_(p, s, 3));
        return true;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return world.m_46859_(pos.m_7494_());
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        world.m_7731_(pos.m_7494_(), (BlockState)this.m_49966_().m_61124_((Property)ISTOP, (Comparable)Boolean.valueOf(true)), 3);
    }

    @Override
    @Deprecated
    public void m_6810_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        boolean isTop = (Boolean)state.m_61143_((Property)ISTOP);
        if (!isTop && newState.m_60795_()) {
            this.spawnItem(world, pos, new ItemStack((ItemLike)this));
        }
        if (state.m_60734_() != newState.m_60734_() && newState.m_60734_() != BlockInit.magia_portal && !world.m_5776_()) {
            BlockPos targetPos = isTop ? pos.m_7495_() : pos.m_7494_();
            this.breakBlock((LevelAccessor)world, targetPos);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    @Override
    protected boolean isDrop() {
        return false;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return (Boolean)state.m_61143_((Property)ISTOP) == false ? new TileSturdustCrystal(pos, state) : new TileStove(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return (Boolean)state.m_61143_((Property)ISTOP) == false ? this.createMailBoxTicker(world, type, TileInit.sturdust_crystal) : null;
    }

    public ItemStack m_7397_(BlockGetter get, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)BlockInit.sturdust_crystal);
    }

    @Override
    public float getEnchantPower() {
        return 2.5f;
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        toolTip.add((Component)this.getText(this.name).m_130940_(GREEN));
        toolTip.add((Component)this.getText(this.name + "_boss").m_130940_(GOLD));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> build) {
        build.m_61104_(new Property[]{FACING, ISTOP});
    }

    public static Map<BlockPos, BlockState> getXPosMap(BlockPos pos) {
        int addZ;
        int addY;
        int addX;
        LinkedHashMap<BlockPos, BlockState> map = new LinkedHashMap<BlockPos, BlockState>();
        pos = pos.m_7495_();
        BlockState portal = (BlockState)BlockInit.magia_portal.m_49966_().m_61124_(MagiaPortal.AXIS, (Comparable)Direction.Axis.X);
        BlockState flame = BlockInit.design_brick_w.m_49966_();
        BlockState flame_b = BlockInit.whiteline_brick_b.m_49966_();
        BlockState flame_l = BlockInit.antique_brick_0l.m_49966_();
        BlockState light = BlockInit.glow_light.m_49966_();
        BlockState railings = BlockInit.iron_railings_b.m_49966_();
        for (addX = -2; addX < 3; ++addX) {
            map.put(WorldHelper.offset(pos, addX, 1.0, -3.0), railings);
            map.put(WorldHelper.offset(pos, addX, 1.0, 3.0), railings);
        }
        map.put(WorldHelper.offset(pos, -2.0, 1.0, -2.0), railings);
        map.put(WorldHelper.offset(pos, 2.0, 1.0, -2.0), railings);
        map.put(WorldHelper.offset(pos, -2.0, 1.0, 2.0), railings);
        map.put(WorldHelper.offset(pos, 2.0, 1.0, 2.0), railings);
        for (addY = 1; addY < 7; ++addY) {
            for (addZ = -3; addZ < 4; ++addZ) {
                map.put(WorldHelper.offset(pos, 0.0, addY, addZ), flame_l);
            }
        }
        for (addY = 0; addY < 6; ++addY) {
            for (addZ = -2; addZ < 3; ++addZ) {
                map.put(WorldHelper.offset(pos, 0.0, addY, addZ), flame);
            }
        }
        for (addX = -2; addX < 3; ++addX) {
            for (addZ = -3; addZ < 4; ++addZ) {
                map.put(WorldHelper.offset(pos, addX, 0.0, addZ), flame_b);
            }
        }
        for (addX = -1; addX < 2; ++addX) {
            for (addZ = -2; addZ < 3; ++addZ) {
                map.put(WorldHelper.offset(pos, addX, 0.0, addZ), flame);
            }
        }
        for (addY = 1; addY < 5; ++addY) {
            for (addZ = -1; addZ < 2; ++addZ) {
                map.put(WorldHelper.offset(pos, 0.0, addY, addZ), portal);
            }
        }
        map.put(WorldHelper.offset(pos, -2.0, 0.0, -3.0), light);
        map.put(WorldHelper.offset(pos, 2.0, 0.0, -3.0), light);
        map.put(WorldHelper.offset(pos, -2.0, 0.0, 3.0), light);
        map.put(WorldHelper.offset(pos, 2.0, 0.0, 3.0), light);
        return map;
    }

    public static Map<BlockPos, BlockState> getZPosMap(BlockPos pos) {
        int addZ;
        int addY;
        int addX;
        LinkedHashMap<BlockPos, BlockState> map = new LinkedHashMap<BlockPos, BlockState>();
        pos = pos.m_7495_();
        BlockState portal = (BlockState)BlockInit.magia_portal.m_49966_().m_61124_(MagiaPortal.AXIS, (Comparable)Direction.Axis.Z);
        BlockState flame = BlockInit.design_brick_w.m_49966_();
        BlockState flame_b = BlockInit.whiteline_brick_b.m_49966_();
        BlockState flame_l = BlockInit.antique_brick_0l.m_49966_();
        BlockState light = BlockInit.glow_light.m_49966_();
        BlockState railings = BlockInit.iron_railings_b.m_49966_();
        for (addX = -2; addX < 3; ++addX) {
            map.put(WorldHelper.offset(pos, -3.0, 1.0, addX), railings);
            map.put(WorldHelper.offset(pos, 3.0, 1.0, addX), railings);
        }
        map.put(WorldHelper.offset(pos, -2.0, 1.0, -2.0), railings);
        map.put(WorldHelper.offset(pos, -2.0, 1.0, 2.0), railings);
        map.put(WorldHelper.offset(pos, 2.0, 1.0, -2.0), railings);
        map.put(WorldHelper.offset(pos, 2.0, 1.0, 2.0), railings);
        for (addY = 1; addY < 7; ++addY) {
            for (addZ = -3; addZ < 4; ++addZ) {
                map.put(WorldHelper.offset(pos, addZ, addY, 0.0), flame_l);
            }
        }
        for (addY = 0; addY < 6; ++addY) {
            for (addZ = -2; addZ < 3; ++addZ) {
                map.put(WorldHelper.offset(pos, addZ, addY, 0.0), flame);
            }
        }
        for (addX = -2; addX < 3; ++addX) {
            for (addZ = -3; addZ < 4; ++addZ) {
                map.put(WorldHelper.offset(pos, addZ, 0.0, addX), flame_b);
            }
        }
        for (addX = -1; addX < 2; ++addX) {
            for (addZ = -2; addZ < 3; ++addZ) {
                map.put(WorldHelper.offset(pos, addZ, 0.0, addX), flame);
            }
        }
        for (addY = 1; addY < 5; ++addY) {
            for (addZ = -1; addZ < 2; ++addZ) {
                map.put(WorldHelper.offset(pos, addZ, addY, 0.0), portal);
            }
        }
        map.put(WorldHelper.offset(pos, -3.0, 0.0, -2.0), light);
        map.put(WorldHelper.offset(pos, -3.0, 0.0, 2.0), light);
        map.put(WorldHelper.offset(pos, 3.0, 0.0, -2.0), light);
        map.put(WorldHelper.offset(pos, 3.0, 0.0, 2.0), light);
        return map;
    }
}

