/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.BlockInit;
import sweetmagic.init.block.base.BaseFaceBlock;

public class AwningTent
extends BaseFaceBlock {
    private static final VoxelShape AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final IntegerProperty CENTER = IntegerProperty.m_61631_((String)"center", (int)0, (int)5);

    public AwningTent(String name) {
        super(name, AwningTent.setState(Material.f_76320_, SoundType.f_56745_, 0.35f, 8192.0f));
        this.m_49959_((BlockState)this.setState().m_61124_((Property)CENTER, (Comparable)Integer.valueOf(0)));
        BlockInit.BlockInfo.create(this, SweetMagicCore.smTab, name);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext col) {
        return AABB;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext con) {
        return this.setVertical(super.m_5573_(con), (LevelAccessor)con.m_43725_(), con.m_8083_());
    }

    public BlockState m_7417_(BlockState state, Direction face, BlockState state2, LevelAccessor world, BlockPos pos1, BlockPos pos2) {
        return this.setVertical(super.m_7417_(state, face, state2, world, pos1, pos2), world, pos1);
    }

    public BlockState setVertical(BlockState state, LevelAccessor world, BlockPos pos) {
        return (BlockState)state.m_61124_((Property)CENTER, (Comparable)Integer.valueOf(this.checkCenter(world, state, pos)));
    }

    public int checkCenter(LevelAccessor world, BlockState state, BlockPos pos) {
        Direction face = (Direction)state.m_61143_((Property)FACING);
        BlockState north = world.m_8055_(pos.m_122012_());
        BlockState south = world.m_8055_(pos.m_122019_());
        BlockState west = world.m_8055_(pos.m_122024_());
        BlockState east = world.m_8055_(pos.m_122029_());
        if (this.isAwning(north, south, west, east)) {
            return 5;
        }
        if (this.isCenter(north, south, west, east)) {
            return 0;
        }
        switch (face) {
            case NORTH: {
                return this.getConnect(north, south, face);
            }
            case SOUTH: {
                return this.getConnect(south, north, face);
            }
            case WEST: {
                return this.getConnect(west, east, face);
            }
            case EAST: {
                return this.getConnect(east, west, face);
            }
        }
        return 0;
    }

    public int getConnect(BlockState block1, BlockState block2, Direction face) {
        if (this.canConnectBlock(block2, face.m_122427_())) {
            return 3;
        }
        if (this.canConnectBlock(block2, face.m_122428_())) {
            return 4;
        }
        if (this.canConnectBlock(block1, face.m_122427_())) {
            return 1;
        }
        if (this.canConnectBlock(block1, face.m_122428_())) {
            return 2;
        }
        return 0;
    }

    public boolean isCenter(BlockState ... stateArray) {
        int awningValue = 0;
        int fullValue = 0;
        for (BlockState state : stateArray) {
            if (state.m_60815_()) {
                ++fullValue;
                continue;
            }
            if (!this.isAwning(state)) continue;
            ++awningValue;
        }
        return awningValue == 3 || awningValue >= 2 && fullValue == 1;
    }

    public boolean canConnectBlock(BlockState state, Direction face) {
        return this.isAwning(state) && face == state.m_61143_((Property)FACING);
    }

    public boolean isAwning(BlockState state) {
        return state.m_60734_() instanceof AwningTent;
    }

    public boolean isAwning(BlockState ... stateArray) {
        int awningValue = 0;
        boolean fullValue = false;
        for (BlockState state : stateArray) {
            if (state.m_60795_()) {
                return false;
            }
            if (!this.isAwning(state)) continue;
            ++awningValue;
        }
        return awningValue >= 3 && fullValue <= true;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> build) {
        build.m_61104_(new Property[]{CENTER, FACING});
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        toolTip.add((Component)this.getText("awning_tent").m_130940_(GREEN));
    }
}

