/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.util.EnumVertical;
import sweetmagic.init.BlockInit;
import sweetmagic.init.block.base.BaseModelBlock;

public class FlowerBuscket
extends BaseModelBlock {
    private static final VoxelShape AABB = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final EnumProperty<EnumVertical> VERTICAL = EnumProperty.m_61587_((String)"vertical", EnumVertical.class);

    public FlowerBuscket(String name) {
        super(name, FlowerBuscket.setState(Material.f_76320_, SoundType.f_56740_, 0.05f, 8192.0f));
        this.m_49959_((BlockState)this.m_49966_().m_61124_(VERTICAL, (Comparable)((Object)EnumVertical.NOR)));
        BlockInit.BlockInfo.create(this, SweetMagicCore.smTab, name);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext con) {
        return AABB;
    }

    @Override
    public boolean canRightClick(Player player, ItemStack stack) {
        return player != null && !stack.m_41619_();
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        BlockItem blockItem;
        if (world.m_5776_()) {
            return true;
        }
        Item item = stack.m_41720_();
        if (!(item instanceof BlockItem) || !((blockItem = (BlockItem)item).m_40614_() instanceof FlowerBuscket)) {
            return false;
        }
        Block block = this.getBlock(stack);
        if (block != this) {
            return false;
        }
        for (int i = 1; i < 11; ++i) {
            BlockPos targetPos = pos.m_6625_(i);
            BlockState state = world.m_8055_(targetPos);
            Block targetBlock = state.m_60734_();
            if (!state.m_60795_() && !(targetBlock instanceof FlowerBuscket)) {
                return false;
            }
            if (!state.m_60795_()) continue;
            world.m_7731_(targetPos, block.m_49966_(), 3);
            this.blockSound(world, block, targetPos, player);
            if (player.m_7500_()) break;
            stack.m_41774_(1);
            break;
        }
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> build) {
        build.m_61104_(new Property[]{VERTICAL});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext con) {
        return this.setVertical((LevelAccessor)con.m_43725_(), con.m_8083_());
    }

    public BlockState setVertical(LevelAccessor world, BlockPos pos) {
        boolean bot = this.getBlock(world, pos.m_7495_()) instanceof FlowerBuscket;
        boolean top = this.getBlock(world, pos.m_7494_()) instanceof FlowerBuscket;
        return (BlockState)this.m_49966_().m_61124_(VERTICAL, (Comparable)((Object)EnumVertical.getVertical(bot, top)));
    }

    public BlockState m_7417_(BlockState state, Direction face, BlockState state2, LevelAccessor world, BlockPos pos1, BlockPos pos2) {
        return this.setVertical(world, pos1);
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        toolTip.add((Component)this.getText("is_vertical").m_130940_(GOLD));
    }
}

