/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.iblock.ISMCraftBlock;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.base.BaseCookBlock;
import sweetmagic.init.block.sm.Stove;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileFrypan;
import sweetmagic.recipe.RecipeHelper;
import sweetmagic.recipe.base.AbstractRecipe;
import sweetmagic.recipe.frypan.FrypanRecipe;
import sweetmagic.util.FaceAABB;

public class Frypan
extends BaseCookBlock
implements ISMCraftBlock {
    private final int data;
    private static final VoxelShape[] AABB = FaceAABB.create(3.75, 0.0, 4.75, 12.25, 2.0, 15.25);

    public Frypan(String name) {
        super(name);
        this.data = 0;
    }

    public Frypan(String name, int data) {
        super(name, SweetMagicCore.smTab);
        this.data = data;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext col) {
        return FaceAABB.getAABB(AABB, state);
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        if (world.m_5776_()) {
            return true;
        }
        BlockState state = world.m_8055_(pos);
        int cookState = this.getState(state);
        if (cookState == 0 && this.isUnderStove(world, pos) && !stack.m_41619_()) {
            this.recipeCraft(world, pos, player, stack);
        } else if (cookState == 2) {
            TileFrypan tile = (TileFrypan)this.getTile(TileFrypan::new, world, pos);
            this.spawnXp(player, tile.resultList, tile.hasFork);
            this.spawnItemList(world, player.m_20183_(), tile.resultList);
            tile.player = player;
            tile.getExpValue();
            this.setState(world, pos, 0);
            tile.clearInfo();
            tile.sendPKT();
        }
        return true;
    }

    public void recipeCraft(Level world, BlockPos pos, Player player, ItemStack stack) {
        List<ItemStack> stackList = RecipeHelper.getPlayerInv(player, stack);
        Optional<FrypanRecipe> recipe = FrypanRecipe.getRecipe(world, stackList);
        if (recipe.isEmpty()) {
            this.cookedFurnaceRecipe(world, pos, player, stack);
            return;
        }
        RecipeHelper.RecipeUtil recipeUtil = RecipeHelper.recipeAllCraft(stackList, recipe.get());
        TileFrypan tile = (TileFrypan)this.getTile(TileFrypan::new, world, pos);
        tile.craftList = recipeUtil.getInputList();
        tile.resultList = recipeUtil.getResultList();
        tile.hasFork = this.hasFork(player);
        tile.amount = recipeUtil.getCount();
        tile.player = player;
        tile.craftStart();
    }

    public void cookedFurnaceRecipe(Level world, BlockPos pos, Player player, ItemStack stack) {
        Optional recipe = world.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{stack}), world);
        if (recipe.isEmpty()) {
            return;
        }
        ItemStack result = ((SmeltingRecipe)recipe.get()).m_8043_().m_41777_();
        if (result.m_41619_() || !result.m_41720_().m_41472_()) {
            return;
        }
        result.m_41764_(stack.m_41613_());
        TileFrypan tile = (TileFrypan)this.getTile(TileFrypan::new, world, pos);
        tile.craftList.add(stack.m_41777_());
        tile.resultList.add(result);
        tile.craftStart();
        stack.m_41774_(stack.m_41613_());
    }

    @Override
    public void onRemove(Level world, BlockPos pos, BlockState state, TileAbstractSM tile) {
        Block block;
        if (this.getState(state) != 0 && (block = this.getBlock(world, pos.m_7495_())) instanceof Stove) {
            Stove stove = (Stove)block;
            stove.setState(world, pos.m_7495_(), 0);
        }
        super.onRemove(world, pos, state, tile);
    }

    @Override
    public void setState(Level world, BlockPos pos, int data) {
        super.setState(world, pos, data);
        Block block = this.getBlock(world, pos.m_7495_());
        if (block instanceof Stove) {
            Stove stove = (Stove)block;
            stove.setState(world, pos.m_7495_(), data);
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileFrypan(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return this.createMailBoxTicker(world, type, TileInit.frypan);
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        super.addBlockTip(toolTip);
        toolTip.add((Component)this.getText("under_stove").m_130940_(GREEN));
        if (this.data != 0) {
            toolTip.add((Component)this.getText("frypan_use").m_130940_(GOLD));
        }
    }

    @Override
    public boolean notNullRecipe(Level world, List<ItemStack> stackList) {
        return !FrypanRecipe.getRecipe(world, stackList).isEmpty();
    }

    @Override
    public AbstractRecipe getRecipe(Level world, List<ItemStack> stackList) {
        return FrypanRecipe.getRecipe(world, stackList).get();
    }
}

