/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidStack;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.iblock.ISMCookBlock;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.base.BaseFaceBlock;
import sweetmagic.init.item.sm.SMBucket;
import sweetmagic.init.tile.sm.TileJuiceMaker;
import sweetmagic.util.FaceAABB;

public class JuiceMaker
extends BaseFaceBlock
implements EntityBlock,
ISMCookBlock {
    private final int data;
    private static final VoxelShape[] AABB = FaceAABB.create(2.0, 0.0, 1.0, 13.0, 11.0, 15.0);
    private static final VoxelShape[] CAFFEE = FaceAABB.create(4.0, 0.0, 3.0, 12.0, 14.5, 15.0);

    public JuiceMaker(String name) {
        super(name, JuiceMaker.setState(Material.f_76279_, SoundType.f_56743_, 0.5f, 8192.0f));
        this.m_49959_(this.setState());
        BlockInit.BlockInfo.create(this, SweetMagicCore.smFoodTab, name);
        this.data = 0;
    }

    public JuiceMaker(String name, int data) {
        super(name, JuiceMaker.setState(Material.f_76279_, SoundType.f_56743_, 0.5f, 8192.0f));
        this.m_49959_(this.setState());
        BlockInit.BlockInfo.create(this, SweetMagicCore.smTab, name);
        this.data = data;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext con) {
        return switch (this.data) {
            case 1 -> FaceAABB.getAABB(CAFFEE, state);
            default -> FaceAABB.getAABB(AABB, state);
        };
    }

    @Override
    public boolean canRightClick(Player player, ItemStack stack) {
        return true;
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        Item item;
        if (world.m_5776_()) {
            return true;
        }
        TileJuiceMaker tile = (TileJuiceMaker)this.getTile(world, pos);
        if (stack.m_150930_(Items.f_42447_)) {
            if (!tile.canInsertWater(1000)) {
                return false;
            }
            stack.m_41774_(1);
            this.spawnItemList(world, player.m_20183_(), Arrays.asList(new ItemStack((ItemLike)Items.f_42446_)));
            tile.setAmount(tile.getFluidValue() + 1000);
            tile.sendPKT();
            this.playerSound(world, pos, SoundEvents.f_11781_, 1.0f, 1.0f);
            return true;
        }
        if (stack.m_150930_(ItemInit.alt_bucket_water) && (item = stack.m_41720_()) instanceof SMBucket) {
            SMBucket bk = (SMBucket)item;
            FluidStack fluid = bk.getFluidStack(stack);
            int insertWaterValue = Math.min(1000, fluid.getAmount());
            fluid.shrink(insertWaterValue);
            bk.saveFluid(stack, fluid);
            tile.setAmount(tile.getFluidValue() + insertWaterValue);
            tile.sendPKT();
            this.playerSound(world, pos, SoundEvents.f_11781_, 1.0f, 1.0f);
            if (fluid.isEmpty() || fluid.getAmount() <= 0) {
                stack.m_41774_(1);
                this.spawnItemList(world, player.m_20183_(), Arrays.asList(new ItemStack((ItemLike)ItemInit.alt_bucket)));
            }
            return true;
        }
        tile.player = player;
        this.openGUI(world, pos, player, tile);
        return true;
    }

    @Override
    public boolean isKeepTile() {
        return true;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileJuiceMaker(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return this.createMailBoxTicker(world, type, TileInit.juicemaker);
    }

    @Override
    protected boolean isDrop() {
        return false;
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        if (this.data != 0) {
            toolTip.add((Component)this.getText("juice_maker_use").m_130940_(GOLD));
        }
    }
}

