/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.ITeleporter;
import sweetmagic.init.BlockInit;
import sweetmagic.init.DimentionInit;
import sweetmagic.init.block.base.BaseModelBlock;
import sweetmagic.util.DimentionTeleporter;
import sweetmagic.util.FaceAABB;

public class MagiaPortal
extends BaseModelBlock {
    private final Block frame;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    private static final VoxelShape BOT = Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
    protected static final VoxelShape[] AABB = FaceAABB.create(0.0, 0.0, 6.0, 16.0, 16.0, 10.0);
    private final Direction[] faceArrayX = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.UP, Direction.DOWN};
    private final Direction[] faceArrayZ = new Direction[]{Direction.WEST, Direction.EAST, Direction.UP, Direction.DOWN};
    private final Direction[] faceArrayY = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};

    public MagiaPortal(String name, Block frame) {
        super(name, MagiaPortal.setState(Material.f_76298_, SoundType.f_56744_, -1.0f, 8192.0f, 15).m_60910_());
        this.frame = frame;
        this.m_49959_((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)Direction.Axis.X));
        BlockInit.BlockInfo.create(this, null, name);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext con) {
        return FaceAABB.getAABB(AABB, BOT, state);
    }

    public BlockState m_7417_(BlockState state, Direction face, BlockState state2, LevelAccessor world, BlockPos pos, BlockPos pos2) {
        if (state2.m_60734_() == this || !state2.m_60795_()) {
            return super.m_7417_(state, face, state2, world, pos, pos2);
        }
        Direction[] faceArray = null;
        switch ((Direction.Axis)state.m_61143_(AXIS)) {
            case X: {
                faceArray = this.faceArrayX;
                break;
            }
            case Z: {
                faceArray = this.faceArrayZ;
                break;
            }
            case Y: {
                faceArray = this.faceArrayY;
            }
        }
        for (Direction fa : faceArray) {
            if (!world.m_46859_(pos.m_121945_(fa))) continue;
            this.breakBlock(world, pos);
        }
        return super.m_7417_(state, face, state2, world, pos, pos2);
    }

    @Override
    protected boolean isDrop() {
        return false;
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (entity.m_20159_() || entity.m_20160_() || !entity.m_6072_() || entity.m_9236_().m_5776_() || world == null || world.m_46472_() == null) {
            return;
        }
        if (entity.m_20092_()) {
            entity.m_20091_();
        }
        if (entity.m_20092_() || !(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity liv = (LivingEntity)entity;
        entity.m_9236_().m_46473_().m_6180_(world.m_46472_().m_135782_().m_135815_());
        ResourceKey<Level> smDim = DimentionInit.SweetMagicWorld;
        ResourceKey<Level> key = world.m_46472_() == smDim ? Level.f_46428_ : smDim;
        ServerLevel dim = world.m_7654_().m_129880_(key);
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        if (dim != null) {
            entity.changeDimension(dim, (ITeleporter)new DimentionTeleporter(this, this.frame, axis, axis == Direction.Axis.Z));
        }
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        return ItemStack.f_41583_;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return MagiaPortal.rotatePillar(state, rot);
    }

    public static BlockState rotatePillar(BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case Direction.Axis.X -> (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    case Direction.Axis.Z -> (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    default -> state;
                };
            }
        }
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> bui) {
        bui.m_61104_(new Property[]{AXIS});
    }

    public BlockState m_5573_(BlockPlaceContext con) {
        return (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)con.m_43719_().m_122434_());
    }
}

