/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.util.EnumVertical;
import sweetmagic.init.BlockInit;
import sweetmagic.init.block.base.BaseModelBlock;

public class MetalPole
extends BaseModelBlock {
    private static final VoxelShape CEN = Block.m_49796_((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5);
    private static final VoxelShape AABB = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final EnumProperty<EnumVertical> VERTICAL = EnumProperty.m_61587_((String)"vertical", EnumVertical.class);

    public MetalPole(String name, int data) {
        super(name, MetalPole.setState(Material.f_76320_, data == 1 ? SoundType.f_56743_ : SoundType.f_56736_, 0.35f, 8192.0f));
        this.m_49959_((BlockState)this.m_49966_().m_61124_(VERTICAL, (Comparable)((Object)EnumVertical.NOR)));
        BlockInit.BlockInfo.create(this, SweetMagicCore.smTab, name);
    }

    @Override
    public boolean canRightClick(Player player, ItemStack stack) {
        return !stack.m_41619_();
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        BlockItem item;
        Item item2 = stack.m_41720_();
        if (!(item2 instanceof BlockItem) || !this.canSetBlock((item = (BlockItem)item2).m_40614_())) {
            return false;
        }
        if (world.m_5776_()) {
            return true;
        }
        Block block = item.m_40614_();
        for (int i = 1; i < 11; ++i) {
            BlockPos targetPos = pos.m_6630_(i);
            BlockState state = world.m_8055_(targetPos);
            Block targetBlock = state.m_60734_();
            if (!state.m_60795_() && !this.canSetBlock(targetBlock)) {
                return false;
            }
            if (!state.m_60795_()) continue;
            world.m_7731_(targetPos, this.setVertical(block.m_49966_(), (LevelAccessor)world, targetPos), 3);
            this.blockSound(world, block, targetPos, player);
            if (player.m_7500_()) break;
            stack.m_41774_(1);
            break;
        }
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext con) {
        return ((EnumVertical)((Object)state.m_61143_(VERTICAL))).is(EnumVertical.CEN) ? CEN : AABB;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext con) {
        return this.setVertical(super.m_5573_(con), (LevelAccessor)con.m_43725_(), con.m_8083_());
    }

    public BlockState m_7417_(BlockState state, Direction face, BlockState state2, LevelAccessor world, BlockPos pos1, BlockPos pos2) {
        return this.setVertical(super.m_7417_(state, face, state2, world, pos1, pos2), world, pos1);
    }

    public BlockState setVertical(BlockState state, LevelAccessor world, BlockPos pos) {
        boolean bot = this.getBlock(world, pos.m_7495_()) == this;
        boolean top = this.getBlock(world, pos.m_7494_()) == this;
        return (BlockState)this.m_49966_().m_61124_(VERTICAL, (Comparable)((Object)EnumVertical.getVertical(bot, top)));
    }

    public boolean canSetBlock(Block block) {
        return block == this;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> build) {
        build.m_61104_(new Property[]{VERTICAL});
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        toolTip.add((Component)this.getText("is_vertical").m_130940_(GOLD));
    }
}

