/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.BlockInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.base.BaseFaceBlock;
import sweetmagic.init.entity.animal.AbstractSummonMob;
import sweetmagic.init.entity.projectile.AbstractMagicShot;
import sweetmagic.init.tile.sm.TileMirageGlass;

public class MirageGlass
extends BaseFaceBlock
implements EntityBlock {
    private final int data;
    public static final Property<Integer> LIGHT_LEVEL = IntegerProperty.m_61631_((String)"level", (int)0, (int)15);
    public static final BooleanProperty ISVIEW = BooleanProperty.m_61465_((String)"view");

    public MirageGlass(String name, int data) {
        super(name, MirageGlass.setState(Material.f_76275_, SoundType.f_56744_, 0.5f, 8192.0f).m_60953_(b -> (Integer)b.m_61143_(LIGHT_LEVEL)).m_60960_((a, b, c) -> false).m_60971_((a, b, c) -> false));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)ISVIEW, (Comparable)Boolean.valueOf(false)));
        BlockInit.BlockInfo.create(this, SweetMagicCore.smTab, name);
        this.data = data;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos block2, boolean par1) {
        if (world.m_5776_() || this.data != 1 || !world.m_46753_(pos) || ((Boolean)state.m_61143_((Property)ISVIEW)).booleanValue()) {
            return;
        }
        this.setValue(world, pos, true);
    }

    public void setValue(Level world, BlockPos pos, boolean flag) {
        BlockState state1 = world.m_8055_(pos);
        if (((Boolean)state1.m_61143_((Property)ISVIEW)).booleanValue()) {
            return;
        }
        if (this.data == 2) {
            TileMirageGlass tile = (TileMirageGlass)this.getTile(world, pos);
            BlockState state = tile.getState();
            SoundType sound = state.m_60734_().getSoundType(state, (LevelReader)world, pos, null);
            Random rand = new Random();
            if (flag) {
                this.playerSound(world, pos, sound.m_56775_(), 1.5f, 0.9f + rand.nextFloat() * 0.2f);
            }
            if (world instanceof ServerLevel) {
                ServerLevel sever = (ServerLevel)world;
                int count = 16;
                float rate = 0.15f;
                float x = (float)pos.m_123341_() + 0.5f;
                float y = (float)pos.m_123342_() + 0.5f;
                float z = (float)pos.m_123343_() + 0.5f;
                BlockParticleOption par = new BlockParticleOption(ParticleTypes.f_123794_, state);
                for (int i = 0; i < count; ++i) {
                    float addX = rand.nextFloat() - rand.nextFloat();
                    float addY = rand.nextFloat() - rand.nextFloat();
                    float addZ = rand.nextFloat() - rand.nextFloat();
                    sever.m_8767_((ParticleOptions)par, (double)(x + addX), (double)(y + addY), (double)(z + addZ), 4, 0.0, 0.0, 0.0, (double)rate);
                }
            }
        }
        world.m_7731_(pos, (BlockState)state1.m_61124_((Property)ISVIEW, (Comparable)Boolean.valueOf(true)), 2);
        for (Direction face : Direction.values()) {
            BlockState state = world.m_8055_(pos.m_121945_(face));
            if (!state.m_61138_((Property)ISVIEW) || ((Boolean)state.m_61143_((Property)ISVIEW)).booleanValue() || state.m_60734_() != this) continue;
            ((MirageGlass)state.m_60734_()).setValue(world, pos.m_121945_(face), false);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext con) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof TileMirageGlass) {
            TileMirageGlass tile = (TileMirageGlass)blockEntity;
            if (!(tile.state.m_60713_((Block)this) || ((Boolean)state.m_61143_((Property)ISVIEW)).booleanValue() || tile.state.m_60734_() instanceof MirageGlass)) {
                BlockState state2 = tile.getState();
                return state2 != null ? state2.m_60808_(world, pos) : Shapes.m_83144_();
            }
        }
        return this.data == 2 && (Boolean)state.m_61143_((Property)ISVIEW) != false ? Shapes.m_83040_() : Shapes.m_83144_();
    }

    @Override
    public boolean canRightClick(Player player, ItemStack stack) {
        return player != null;
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        BlockItem item;
        TileMirageGlass tile = (TileMirageGlass)this.getTile(world, pos);
        if (this.data == 1 && !player.m_7500_() && !tile.state.m_60713_((Block)this)) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        if (stack.m_41619_() && (!tile.state.m_60713_((Block)this) || ((Boolean)state.m_61143_((Property)ISVIEW)).booleanValue())) {
            tile.state = this.m_49966_();
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)ISVIEW, (Comparable)Boolean.valueOf(false)), 2);
            world.m_46597_(pos, (BlockState)tile.getState(pos).m_61124_(LIGHT_LEVEL, (Comparable)Integer.valueOf(tile.state.getLightEmission((BlockGetter)world, pos))));
            tile.sendPKT();
            this.playerSound(world, pos, SoundEvents.f_12019_, 1.0f, 1.0f);
            return true;
        }
        Item item2 = stack.m_41720_();
        if (!(item2 instanceof BlockItem) || (item = (BlockItem)item2).m_40614_() == this) {
            return false;
        }
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        posList.add(pos);
        this.rangeSetBlock(world, pos, tile, item.m_40614_(), tile.state, posList);
        this.playerSound(world, pos, SoundEvents.f_12019_, 1.0f, 1.0f);
        return true;
    }

    public void rangeSetBlock(Level world, BlockPos pos, TileMirageGlass tile, Block block, BlockState tileState, List<BlockPos> posList) {
        if (world.m_5776_()) {
            return;
        }
        tile.state = block.m_49966_();
        world.m_46597_(pos, (BlockState)tile.getState(pos).m_61124_(LIGHT_LEVEL, (Comparable)Integer.valueOf(tile.state.getLightEmission((BlockGetter)world, pos))));
        tile.sendPKT();
        for (Direction face : Direction.values()) {
            BlockState state;
            BlockPos p = pos.m_121945_(face);
            if (posList.contains(p) || !(state = world.m_8055_(p)).m_60713_((Block)this)) continue;
            TileMirageGlass tile2 = (TileMirageGlass)this.getTile(world, p);
            if (tile2.state != TileMirageGlass.MIRAGE && tile2.state != tileState && !((Boolean)state.m_61143_((Property)ISVIEW)).booleanValue()) continue;
            posList.add(p);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)ISVIEW, (Comparable)Boolean.valueOf(false)), 2);
            ((MirageGlass)state.m_60734_()).rangeSetBlock(world, p, tile2, block, tileState, posList);
        }
    }

    @Nonnull
    public VoxelShape m_5939_(BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, CollisionContext col) {
        EntityCollisionContext con;
        return (this.data == 0 || (Boolean)state.m_61143_((Property)ISVIEW) != false) && col instanceof EntityCollisionContext && this.checkEntity((con = (EntityCollisionContext)col).m_193113_()) ? Shapes.m_83040_() : super.m_5939_(state, world, pos, col);
    }

    public boolean checkEntity(Entity entity) {
        return entity instanceof Player || entity instanceof AbstractSummonMob || entity instanceof AbstractMagicShot;
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        toolTip.add((Component)this.getText("dungen_only").m_130940_(GREEN));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileMirageGlass(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (this.data != 2) {
            return null;
        }
        return this.createMailBoxTicker(level, type, TileInit.mirageGlass);
    }

    @Override
    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public ItemStack m_7397_(BlockGetter get, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)((TileMirageGlass)get.m_7702_((BlockPos)pos)).state.m_60734_());
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> build) {
        build.m_61104_(new Property[]{FACING, LIGHT_LEVEL, ISVIEW});
    }
}

