/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.BlockInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.base.BaseFaceBlock;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileParallelInterfere;
import sweetmagic.init.tile.sm.TileStardustWish;

public class ParallelInterfere
extends BaseFaceBlock
implements EntityBlock {
    private final int data;
    private static final VoxelShape AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);

    public ParallelInterfere(String name, int data) {
        super(name, ParallelInterfere.setState(Material.f_76279_, SoundType.f_56743_, 0.5f, 8192.0f));
        this.m_49959_(this.setState());
        this.data = data;
        BlockInit.BlockInfo.create(this, SweetMagicCore.smTab, name);
    }

    @Override
    public boolean canRightClick(Player player, ItemStack stack) {
        return true;
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        if (world.m_5776_()) {
            return true;
        }
        this.openGUI(world, pos, player, this.getTile(world, pos));
        return true;
    }

    public ItemStack inheritingNBT(ItemStack oldStack, ItemStack newStack) {
        if (oldStack.m_41784_().m_128441_("BlockEntityTag")) {
            CompoundTag tags = oldStack.m_41737_("BlockEntityTag");
            int oldInputSize = 1080;
            tags.m_128405_("Size", oldInputSize);
            CompoundTag newTags = new CompoundTag();
            newTags.m_128365_("BlockEntityTag", (Tag)tags);
            newStack.m_41751_(newTags);
        }
        return newStack;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext con) {
        return AABB;
    }

    @Override
    protected boolean isDrop() {
        return false;
    }

    @Override
    public boolean isKeepTile() {
        return true;
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        toolTip.add((Component)this.getText("parallel_interfere", new Object[]{(this.data + 1) * 20}).m_130940_(GREEN));
        toolTip.add((Component)this.getText("sm_chest").m_130940_(GREEN));
        super.addBlockTip(toolTip);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return switch (this.data) {
            case 1 -> new TileStardustWish(pos, state);
            default -> new TileParallelInterfere(pos, state);
        };
    }

    @Override
    public BlockEntityType<? extends TileAbstractSM> getTileType() {
        return switch (this.data) {
            case 1 -> TileInit.stardustWish;
            default -> TileInit.parallelInterfere;
        };
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return this.createMailBoxTicker(world, type, this.getTileType());
    }

    @Override
    public float getEnchantPower() {
        return (float)(this.data + 1) * 15.0f;
    }
}

