/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.iblock.IFoodExpBlock;
import sweetmagic.init.BlockInit;
import sweetmagic.init.block.base.BaseFaceBlock;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TilePlate;
import sweetmagic.util.ItemHelper;

public class Plate
extends BaseFaceBlock
implements EntityBlock,
IFoodExpBlock {
    public final int data;
    private final Block block;
    private static final VoxelShape PLATE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.5, (double)14.0);
    private static final VoxelShape TRAY = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape DIG = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);

    public Plate(String name, int data, Block block) {
        super(name, Plate.setState(Material.f_76278_, SoundType.f_56742_, 0.5f, 8192.0f));
        this.data = data;
        this.m_49959_(this.setState());
        BlockInit.BlockInfo.create(this, SweetMagicCore.smTab, name);
        this.block = block;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext col) {
        return switch (this.data) {
            case 0 -> PLATE;
            case 1 -> TRAY;
            case 2 -> TRAY;
            case 4 -> DIG;
            default -> Shapes.m_83144_();
        };
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return this.data == 0 ? RenderShape.ENTITYBLOCK_ANIMATED : super.m_7514_(state);
    }

    @Override
    public boolean canRightClick(Player player, ItemStack stack) {
        return true;
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        if (world.m_5776_()) {
            return true;
        }
        TileAbstractSM tileAbstractSM = this.getTile(world, pos);
        if (!(tileAbstractSM instanceof TilePlate)) {
            return false;
        }
        TilePlate tile = (TilePlate)tileAbstractSM;
        ItemStack inputStack = tile.getInputItem(0);
        boolean isSneak = player.m_6144_();
        if (inputStack.m_41619_() || isSneak) {
            if (!stack.m_41619_() && !isSneak) {
                ItemStack copy = stack.m_41777_();
                ItemHelper.insertStack(tile.getInput(), copy, false);
                stack.m_41774_(stack.m_41613_());
                this.playerSound(world, pos, SoundEvents.f_12019_, 0.5f, 1.0f);
            } else {
                this.openGUI(world, pos, player, tile);
            }
        } else {
            this.spawnItemList(world, player.m_20183_(), Arrays.asList(inputStack.m_41777_()));
            inputStack.m_41774_(inputStack.m_41613_());
            this.playerSound(world, pos, SoundEvents.f_12019_, 0.5f, 1.0f);
        }
        tile.sendPKT();
        return true;
    }

    @Override
    protected boolean isDrop() {
        return false;
    }

    @Override
    public boolean isKeepTile() {
        return true;
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        toolTip.add((Component)this.getText("plate").m_130940_(GREEN));
        switch (this.data) {
            case 0: {
                toolTip.add((Component)this.getText("plate_in").m_130940_(GREEN));
                if (this.block == null) {
                    return;
                }
                toolTip.add((Component)this.getText("originatorblock", new Object[]{this.block.m_49954_().getString()}).m_130940_(GOLD));
            }
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TilePlate(pos, state);
    }

    public int getData() {
        return this.data;
    }

    @Override
    public boolean isChanceUp() {
        return this.data == 0;
    }
}

