/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.util.EnumVertical;
import sweetmagic.init.BlockInit;
import sweetmagic.init.block.base.BaseModelBlock;

public class Pole
extends BaseModelBlock {
    private static final VoxelShape AABB = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final BooleanProperty ISDROP = BooleanProperty.m_61465_((String)"isdrop");
    public static final EnumProperty<EnumVertical> VERTICAL = EnumProperty.m_61587_((String)"vertical", EnumVertical.class);

    public Pole(String name) {
        super(name, Pole.setState(Material.f_76320_, SoundType.f_56743_, 0.5f, 8192.0f, 15));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(VERTICAL, (Comparable)((Object)EnumVertical.BOT))).m_61124_((Property)ISDROP, (Comparable)Boolean.valueOf(false)));
        BlockInit.BlockInfo.create(this, SweetMagicCore.smTab, name);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext col) {
        return AABB;
    }

    @Override
    public boolean canRightClick(Player player, ItemStack stack) {
        return !stack.m_41619_();
    }

    public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
        boolean canPlace = false;
        for (int i = 0; i < 5 && (canPlace = reader.m_46859_(pos.m_6630_(i))); ++i) {
        }
        return canPlace;
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item;
        Block block = blockItem.m_40614_();
        if (!(block instanceof Pole)) {
            return false;
        }
        if (world.m_5776_()) {
            return true;
        }
        int addY = 0;
        for (int i = 0; i < 64; ++i) {
            if (!world.m_46859_(pos.m_6630_(i + 1))) continue;
            for (int y = 0; y < 5; ++y) {
                if (world.m_46859_(pos.m_6630_(i + y + 1))) continue;
                return false;
            }
            addY = i;
            break;
        }
        for (int k = 0; k < 5; ++k) {
            int data = 0;
            boolean isDrop = false;
            switch (k) {
                case 0: {
                    data = 0;
                    isDrop = true;
                    break;
                }
                case 3: {
                    data = 2;
                    break;
                }
                default: {
                    data = 1;
                }
            }
            BlockPos p = pos.m_6630_(addY + k + 1);
            world.m_46597_(p, (BlockState)((BlockState)BlockInit.pole.m_49966_().m_61124_(VERTICAL, (Comparable)((Object)EnumVertical.getLocalList().get(data)))).m_61124_((Property)ISDROP, (Comparable)Boolean.valueOf(isDrop)));
            SoundType sound = this.getSoundType(block.m_49966_(), (LevelReader)world, pos, (Entity)player);
            this.playerSound(world, p, sound.m_56777_(), (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
        }
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
        return true;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        for (int i = 0; i < 4; ++i) {
            int data = 0;
            switch (i) {
                case 3: {
                    data = 2;
                    break;
                }
                default: {
                    data = 1;
                }
            }
            world.m_46597_(pos.m_6630_(i + 1), (BlockState)BlockInit.pole.m_49966_().m_61124_(VERTICAL, (Comparable)((Object)EnumVertical.getLocalList().get(data))));
        }
    }

    @Override
    @Deprecated
    public void m_6810_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (((Boolean)state.m_61143_((Property)ISDROP)).booleanValue() && newState.m_60795_()) {
            this.spawnItem(world, pos, new ItemStack((ItemLike)this));
        }
        if (state.m_60734_() != newState.m_60734_() && !world.m_5776_()) {
            BlockPos downPos;
            BlockPos upPos = pos.m_6630_(1);
            if (this.getBlock(world, upPos) instanceof Pole) {
                this.breakBlock((LevelAccessor)world, upPos);
            }
            if (this.getBlock(world, downPos = pos.m_6625_(1)) instanceof Pole) {
                this.breakBlock((LevelAccessor)world, downPos);
            }
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext con) {
        return this.setVertical((LevelAccessor)con.m_43725_(), con.m_8083_());
    }

    public BlockState m_7417_(BlockState state, Direction face, BlockState state2, LevelAccessor world, BlockPos pos1, BlockPos pos2) {
        return this.setVertical(world, state, pos1);
    }

    public BlockState setVertical(LevelAccessor world, BlockPos pos) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_(VERTICAL, (Comparable)((Object)EnumVertical.BOT))).m_61124_((Property)ISDROP, (Comparable)Boolean.valueOf(true));
    }

    public BlockState setVertical(LevelAccessor world, BlockState state, BlockPos pos) {
        boolean bot = this.getBlock(world, pos.m_7495_()) == this;
        boolean top = this.getBlock(world, pos.m_7494_()) == this;
        return (BlockState)((BlockState)state.m_61124_(VERTICAL, (Comparable)((Object)EnumVertical.getVertical(bot, top)))).m_61124_((Property)ISDROP, (Comparable)((Boolean)state.m_61143_((Property)ISDROP)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> build) {
        build.m_61104_(new Property[]{VERTICAL, ISDROP});
    }

    @Override
    protected boolean isDrop() {
        return false;
    }
}

