/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.iblock.ISMCraftBlock;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.base.BaseCookBlock;
import sweetmagic.init.block.sm.Stove;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TilePot;
import sweetmagic.recipe.RecipeHelper;
import sweetmagic.recipe.base.AbstractRecipe;
import sweetmagic.recipe.pot.PotRecipe;
import sweetmagic.util.FaceAABB;

public class Pot
extends BaseCookBlock
implements ISMCraftBlock {
    private final int data;
    private static final VoxelShape[] AABB = FaceAABB.create(2.56, 0.0, 2.56, 13.44, 6.08, 13.44);

    public Pot(String name) {
        super(name);
        this.data = 0;
    }

    public Pot(String name, int data) {
        super(name, SweetMagicCore.smTab);
        this.data = data;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext con) {
        return FaceAABB.getAABB(AABB, state);
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        if (world.m_5776_()) {
            return true;
        }
        BlockState state = world.m_8055_(pos);
        int cookState = this.getState(state);
        if (cookState == 0 && this.isUnderStove(world, pos)) {
            this.recipeCraft(world, pos, player, stack);
        } else if (cookState == 2) {
            TilePot tile = (TilePot)world.m_7702_(pos);
            this.spawnXp(player, tile.resultList, tile.hasFork);
            this.spawnItemList(world, player.m_20183_(), tile.resultList);
            tile.player = player;
            tile.getExpValue();
            this.setState(world, pos, 0);
            tile.clearInfo();
            tile.sendPKT();
        }
        return true;
    }

    public void recipeCraft(Level world, BlockPos pos, Player player, ItemStack stack) {
        List<ItemStack> stackList = RecipeHelper.getPlayerInv(player, stack);
        Optional<PotRecipe> recipe = PotRecipe.getRecipe(world, stackList);
        if (recipe.isEmpty()) {
            return;
        }
        RecipeHelper.RecipeUtil recipeUtil = RecipeHelper.recipeAllCraft(stackList, recipe.get());
        TilePot tile = (TilePot)this.getTile(world, pos);
        tile.craftList = recipeUtil.getInputList();
        tile.resultList = recipeUtil.getResultList();
        tile.hasFork = this.hasFork(player);
        tile.amount = recipeUtil.getCount();
        tile.player = player;
        tile.craftStart();
    }

    @Override
    public void onRemove(Level world, BlockPos pos, BlockState state, TileAbstractSM tile) {
        Block block;
        if (this.getState(state) != 0 && (block = this.getBlock(world, pos.m_7495_())) instanceof Stove) {
            Stove stove = (Stove)block;
            stove.setState(world, pos.m_7495_(), 0);
        }
        super.onRemove(world, pos, state, tile);
    }

    @Override
    public void setState(Level world, BlockPos pos, int data) {
        super.setState(world, pos, data);
        Block block = this.getBlock(world, pos.m_7495_());
        if (block instanceof Stove) {
            Stove stove = (Stove)block;
            stove.setState(world, pos.m_7495_(), data);
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TilePot(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return this.createMailBoxTicker(world, type, TileInit.pot);
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        super.addBlockTip(toolTip);
        toolTip.add((Component)this.getText("under_stove").m_130940_(GREEN));
        if (this.data != 0) {
            toolTip.add((Component)this.getText("pot_use").m_130940_(GOLD));
        }
    }

    @Override
    public boolean notNullRecipe(Level world, List<ItemStack> stackList) {
        return !PotRecipe.getRecipe(world, stackList).isEmpty();
    }

    @Override
    public AbstractRecipe getRecipe(Level world, List<ItemStack> stackList) {
        return PotRecipe.getRecipe(world, stackList).get();
    }
}

