/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.BlockInit;
import sweetmagic.init.block.base.BaseFaceBlock;
import sweetmagic.util.FaceAABB;

public class RollerBlind
extends BaseFaceBlock {
    public static final BooleanProperty CLOSE = BooleanProperty.m_61465_((String)"close");
    public static final IntegerProperty TYPE = IntegerProperty.m_61631_((String)"type", (int)0, (int)3);
    private static final VoxelShape[] AABB = FaceAABB.create(0.0, 0.0, 14.5, 16.0, 16.0, 15.5);

    public RollerBlind(String name) {
        super(name, RollerBlind.setState(Material.f_76272_, SoundType.f_56745_, 0.5f, 8192.0f).m_60960_((a, b, c) -> false).m_60971_((a, b, c) -> false));
        this.m_49959_((BlockState)((BlockState)this.setState().m_61124_((Property)TYPE, (Comparable)Integer.valueOf(0))).m_61124_((Property)CLOSE, (Comparable)Boolean.valueOf(false)));
        BlockInit.BlockInfo.create(this, SweetMagicCore.smTab, name);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext con) {
        return FaceAABB.getAABB(AABB, state);
    }

    @Nonnull
    public VoxelShape m_5939_(BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, CollisionContext col) {
        EntityCollisionContext con;
        if (((Boolean)state.m_61143_((Property)CLOSE)).booleanValue() && col instanceof EntityCollisionContext && (con = (EntityCollisionContext)col).m_193113_() instanceof Player) {
            return Shapes.m_83040_();
        }
        return super.m_5939_(state, world, pos, col);
    }

    @Override
    public boolean canRightClick(Player player, ItemStack stack) {
        return true;
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        BlockItem blockItem;
        Item item;
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() == this) {
            BlockState state = world.m_8055_(pos);
            Block block = state.m_60734_();
            for (int i = 1; i < 11; ++i) {
                BlockPos targetPos = pos.m_6625_(i);
                BlockState targetState = world.m_8055_(targetPos);
                Block targetBlock = targetState.m_60734_();
                if (targetBlock == this) continue;
                if (!targetState.m_60795_()) break;
                world.m_7731_(targetPos, state, 3);
                this.blockSound(world, block, targetPos, player);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                return true;
            }
        }
        world.m_7731_(pos, (BlockState)world.m_8055_(pos).m_61122_((Property)CLOSE), 2);
        this.playerSound(world, pos, SoundEvents.f_12639_, 0.5f, world.m_213780_().m_188501_() * 0.1f + 0.9f);
        return true;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext con) {
        Level world = con.m_43725_();
        BlockPos pos = con.m_8083_();
        BlockState state = super.m_5573_(con);
        BlockState upState = world.m_8055_(pos.m_7494_());
        BlockState downState = world.m_8055_(pos.m_7495_());
        if (upState.m_61138_((Property)CLOSE)) {
            state = (BlockState)state.m_61124_((Property)CLOSE, (Comparable)((Boolean)upState.m_61143_((Property)CLOSE)));
        } else if (downState.m_61138_((Property)CLOSE)) {
            state = (BlockState)state.m_61124_((Property)CLOSE, (Comparable)((Boolean)downState.m_61143_((Property)CLOSE)));
        }
        return this.setVertical(state, (LevelAccessor)world, pos);
    }

    public BlockState m_7417_(BlockState state, Direction face, BlockState state2, LevelAccessor world, BlockPos pos1, BlockPos pos2) {
        if (state2.m_60734_() == this && state2.m_61138_((Property)CLOSE)) {
            state = (BlockState)state.m_61124_((Property)CLOSE, (Comparable)((Boolean)state2.m_61143_((Property)CLOSE)));
        }
        return this.setVertical(super.m_7417_(state, face, state2, world, pos1, pos2), world, pos1);
    }

    public BlockState setVertical(BlockState state, LevelAccessor world, BlockPos pos) {
        BlockState upState = world.m_8055_(pos.m_7494_());
        BlockState downState = world.m_8055_(pos.m_7495_());
        if (upState.m_60734_() != this && downState.m_60734_() != this) {
            return (BlockState)state.m_61124_((Property)TYPE, (Comparable)Integer.valueOf(0));
        }
        if (upState.m_60734_() != this) {
            return (BlockState)state.m_61124_((Property)TYPE, (Comparable)Integer.valueOf(1));
        }
        return (BlockState)state.m_61124_((Property)TYPE, (Comparable)Integer.valueOf(downState.m_60734_() == this ? 2 : 3));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> build) {
        build.m_61104_(new Property[]{TYPE, CLOSE, FACING});
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        toolTip.add((Component)this.getText("is_vertical").m_130940_(GOLD));
        toolTip.add((Component)this.getText("roller_blind").m_130940_(GREEN));
    }
}

