/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.common.ForgeHooks;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.iblock.ISMCrop;
import sweetmagic.init.BlockInit;
import sweetmagic.init.block.base.BaseSMBlock;
import sweetmagic.worldgen.tree.gen.AbstractTreeGen;
import sweetmagic.worldgen.tree.gen.CoconutTreeGen;
import sweetmagic.worldgen.tree.gen.EstorTreeGen;
import sweetmagic.worldgen.tree.gen.MagiaTreeGen;
import sweetmagic.worldgen.tree.gen.PrismTreeGen;
import sweetmagic.worldgen.tree.gen.SMTreeGen;

public class SMSapling
extends SaplingBlock {
    public final String name;
    private final int data;

    public SMSapling(String name, int data) {
        super(null, BaseSMBlock.setState(Material.f_76300_, SoundType.f_56740_, 0.0f, 8192.0f).m_60910_().m_60977_());
        BlockInit.BlockInfo.create((Block)this, SweetMagicCore.smTab, name);
        this.data = data;
        this.name = name;
        BlockInit.saplingList.add((Block)this);
    }

    public Block getLog() {
        return switch (this.data) {
            case 1 -> BlockInit.lemon_log;
            case 2 -> BlockInit.orange_log;
            case 3 -> BlockInit.coconut_log;
            case 4 -> BlockInit.prism_log;
            case 5 -> Blocks.f_50002_;
            case 6 -> BlockInit.estor_log;
            case 7 -> BlockInit.peach_log;
            case 8 -> BlockInit.magiawood_log;
            case 9 -> BlockInit.cherry_blossoms_log;
            case 10 -> BlockInit.maple_log;
            default -> BlockInit.chestnut_log;
        };
    }

    public BlockState getLeaves() {
        return switch (this.data) {
            case 1 -> BlockInit.lemon_leaves.m_49966_();
            case 2 -> BlockInit.orange_leaves.m_49966_();
            case 3 -> BlockInit.coconut_leaves.m_49966_();
            case 4 -> BlockInit.prism_leaves.m_49966_();
            case 5 -> BlockInit.banana_leaves.m_49966_();
            case 6 -> BlockInit.estor_leaves.m_49966_();
            case 7 -> BlockInit.peach_leaves.m_49966_();
            case 8 -> BlockInit.magiawood_leaves.m_49966_();
            case 9 -> BlockInit.cherry_blossoms_leaves.m_49966_();
            case 10 -> (BlockState)BlockInit.maple_leaves.m_49966_().m_61124_((Property)ISMCrop.AGE5, (Comparable)Integer.valueOf(new Random().nextInt(6)));
            default -> BlockInit.chestnut_leaves.m_49966_();
        };
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (ForgeHooks.onCropsGrowPre((Level)world, (BlockPos)pos, (BlockState)state, (boolean)this.isGlowChange(rand))) {
            this.m_222000_(world, pos, state, rand);
        }
    }

    public boolean isGlowChange(RandomSource rand) {
        return rand.m_188503_(2) == 0;
    }

    public AbstractTreeGen getTreeGen() {
        return switch (this.data) {
            case 3 -> new CoconutTreeGen(this.getLog().m_49966_(), this.getLeaves(), BlockInit.coconut_plant.m_49966_(), 0);
            case 4 -> new PrismTreeGen(this.getLog().m_49966_(), this.getLeaves(), 0);
            case 5 -> new CoconutTreeGen(this.getLog().m_49966_(), this.getLeaves(), BlockInit.banana_plant.m_49966_(), 0);
            case 6 -> new EstorTreeGen(this.getLog().m_49966_(), this.getLeaves(), 0);
            case 8 -> new MagiaTreeGen(this.getLog().m_49966_(), this.getLeaves(), 0);
            default -> new SMTreeGen(this.getLog().m_49966_(), this.getLeaves(), 0);
        };
    }

    public void m_222000_(ServerLevel world, BlockPos pos, BlockState state, RandomSource rand) {
        if (state.m_61138_((Property)f_55973_) && (Integer)state.m_61143_((Property)f_55973_) == 0) {
            world.m_7731_(pos, (BlockState)state.m_61122_((Property)f_55973_), 4);
        } else {
            this.getTreeGen().generate((Level)world, rand, pos);
        }
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder build) {
        return Arrays.asList(new ItemStack((ItemLike)this));
    }
}

