/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.BlockInit;
import sweetmagic.init.block.base.BaseFaceBlock;
import sweetmagic.init.entity.block.Chair;
import sweetmagic.util.FaceAABB;

public class Sofa
extends BaseFaceBlock {
    public static final BooleanProperty LEFT = BooleanProperty.m_61465_((String)"left");
    public static final BooleanProperty RIGHT = BooleanProperty.m_61465_((String)"right");
    public static final IntegerProperty CENTER = IntegerProperty.m_61631_((String)"center", (int)0, (int)4);
    private static final VoxelShape[] AABB = FaceAABB.create(0.0, 0.0, 1.0, 16.0, 12.5, 16.0);

    public Sofa(String name) {
        super(name, Sofa.setState(Material.f_76272_, SoundType.f_56745_, 0.5f, 8192.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.setState().m_61124_((Property)CENTER, (Comparable)Integer.valueOf(0))).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(false)));
        BlockInit.BlockInfo.create(this, SweetMagicCore.smTab, name);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext col) {
        return FaceAABB.getAABB(AABB, state);
    }

    @Override
    public boolean canRightClick(Player player, ItemStack stack) {
        return true;
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        double y = 0.35;
        Chair.create(world, pos, y, player, (Direction)world.m_8055_(pos).m_61143_((Property)FACING));
        return true;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext con) {
        return this.setVertical(super.m_5573_(con), (LevelAccessor)con.m_43725_(), con.m_8083_());
    }

    public BlockState m_7417_(BlockState state, Direction face, BlockState state2, LevelAccessor world, BlockPos pos1, BlockPos pos2) {
        return this.setVertical(super.m_7417_(state, face, state2, world, pos1, pos2), world, pos1);
    }

    public BlockState setVertical(BlockState state, LevelAccessor world, BlockPos pos) {
        Direction face = (Direction)state.m_61143_((Property)FACING);
        BlockState north = world.m_8055_(pos.m_122012_());
        BlockState south = world.m_8055_(pos.m_122019_());
        BlockState west = world.m_8055_(pos.m_122024_());
        BlockState east = world.m_8055_(pos.m_122029_());
        int center = this.checkCenter(world, state, pos);
        state = (BlockState)state.m_61124_((Property)CENTER, (Comparable)Integer.valueOf(center));
        return switch (face) {
            case Direction.NORTH -> (BlockState)((BlockState)state.m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(this.isShowCase(face, west, center)))).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(this.isShowCase(face, east, center)));
            case Direction.SOUTH -> (BlockState)((BlockState)state.m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(this.isShowCase(face, east, center)))).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(this.isShowCase(face, west, center)));
            case Direction.WEST -> (BlockState)((BlockState)state.m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(this.isShowCase(face, south, center)))).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(this.isShowCase(face, north, center)));
            case Direction.EAST -> (BlockState)((BlockState)state.m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(this.isShowCase(face, north, center)))).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(this.isShowCase(face, south, center)));
            default -> state;
        };
    }

    public int checkCenter(LevelAccessor world, BlockState state, BlockPos pos) {
        Direction face = (Direction)state.m_61143_((Property)FACING);
        BlockState north = world.m_8055_(pos.m_122012_());
        BlockState south = world.m_8055_(pos.m_122019_());
        BlockState west = world.m_8055_(pos.m_122024_());
        BlockState east = world.m_8055_(pos.m_122029_());
        return switch (face) {
            case Direction.NORTH -> this.getConnect(north, south, face);
            case Direction.SOUTH -> this.getConnect(south, north, face);
            case Direction.WEST -> this.getConnect(west, east, face);
            case Direction.EAST -> this.getConnect(east, west, face);
            default -> 0;
        };
    }

    public int getConnect(BlockState block1, BlockState block2, Direction face) {
        if (this.canConnectBlock(block2, face.m_122427_())) {
            return 3;
        }
        if (this.canConnectBlock(block2, face.m_122428_())) {
            return 4;
        }
        if (this.canConnectBlock(block1, face.m_122427_())) {
            return 1;
        }
        if (this.canConnectBlock(block1, face.m_122428_())) {
            return 2;
        }
        return 0;
    }

    public boolean canConnectBlock(BlockState state, Direction face) {
        return this.isCounter(state) && face == state.m_61143_((Property)FACING);
    }

    public boolean isShowCase(Direction face, BlockState state, int center) {
        return state.m_60734_() == this && (face == state.m_61143_((Property)FACING) || face.m_122427_() == state.m_61143_((Property)FACING) || face.m_122428_() == state.m_61143_((Property)FACING));
    }

    public boolean isCounter(BlockState state) {
        return state.m_60734_() == this;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> build) {
        build.m_61104_(new Property[]{CENTER, LEFT, RIGHT, FACING});
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        toolTip.add((Component)this.getText("conect").m_130940_(GREEN));
    }
}

