/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.BlockInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.base.BaseFaceBlock;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileStove;
import sweetmagic.init.tile.sm.TileTransferGate;
import sweetmagic.util.FaceAABB;

public class TransferGate
extends BaseFaceBlock
implements EntityBlock {
    private final int data;
    private int tickTime = 25;
    private static final VoxelShape[] AABB = FaceAABB.create(-6.0, 0.0, -4.0, 22.0, 2.0, 20.0);
    private static final VoxelShape[] TOP = FaceAABB.create(-14.0, -14.0, 7.0, 30.0, 30.0, 9.0);

    public TransferGate(String name, int data) {
        super(name, TransferGate.setState(Material.f_76279_, SoundType.f_56743_, 2.0f, 8192.0f));
        this.data = data;
        BlockInit.BlockInfo.create(this, (CreativeModeTab)(data == 0 ? SweetMagicCore.smMagicTab : null), name);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext con) {
        return this.data == 0 ? FaceAABB.getAABB(AABB, state) : FaceAABB.getAABB(TOP, state);
    }

    @Override
    protected boolean isDrop() {
        return false;
    }

    @Override
    public boolean canRightClick(Player player, ItemStack stack) {
        return !player.m_21023_(PotionInit.non_destructive);
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        if (world.m_5776_()) {
            return true;
        }
        pos = this.data == 1 ? pos : pos.m_7494_();
        this.openGUI(world, pos, player, this.getTile(world, pos));
        return true;
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        toolTip.add((Component)this.getText("transfer_gate_vertical").m_130940_(GREEN));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.data == 1 ? new TileTransferGate(pos, state) : new TileStove(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return this.createMailBoxTicker(world, type, (BlockEntityType<? extends TileAbstractSM>)(this.data == 1 ? TileInit.transferGate : null));
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (world.m_5776_() || this.tickTime++ % 30 != 0 || !(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (this.data == 0) {
            TileTransferGate tile;
            TileAbstractSM bEntity = this.getTile(world, pos.m_7494_());
            if (bEntity != null && bEntity instanceof TileTransferGate && (tile = (TileTransferGate)bEntity).doTereport(living)) {
                this.tickTime = 25;
            }
            return;
        }
        Direction face = (Direction)state.m_61143_((Property)FACING);
        for (int i = 1; i < 512; ++i) {
            BlockPos newPos = pos;
            switch (face) {
                case NORTH: {
                    newPos = pos.m_122020_(i);
                    break;
                }
                case SOUTH: {
                    newPos = pos.m_122013_(i);
                    break;
                }
                case WEST: {
                    newPos = pos.m_122030_(i);
                    break;
                }
                case EAST: {
                    newPos = pos.m_122025_(i);
                }
            }
            BlockState targetState = world.m_8055_(newPos);
            if (!targetState.m_60713_(BlockInit.transfer_gate_top)) continue;
            face = (Direction)targetState.m_61143_((Property)FACING);
            switch (face) {
                case NORTH: {
                    newPos = newPos.m_122013_(2);
                    break;
                }
                case SOUTH: {
                    newPos = newPos.m_122020_(2);
                    break;
                }
                case WEST: {
                    newPos = newPos.m_122025_(2);
                    break;
                }
                case EAST: {
                    newPos = newPos.m_122030_(2);
                }
            }
            entity.m_6021_((double)newPos.m_123341_() + 0.5, (double)newPos.m_123342_() + 0.5, (double)newPos.m_123343_() + 0.5);
            this.playerSound(world, newPos, SoundEvents.f_11852_, 1.0f, 1.0f);
            this.tickTime = 25;
            break;
        }
    }

    @Nonnull
    public VoxelShape m_5939_(BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, CollisionContext con) {
        return Shapes.m_83040_();
    }

    public ItemStack m_7397_(BlockGetter get, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)BlockInit.transfer_gate);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        world.m_7731_(pos.m_7494_(), (BlockState)BlockInit.transfer_gate_top.m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))), 3);
    }

    @Override
    public void onRemove(Level world, BlockPos pos, BlockState state, TileAbstractSM tile) {
        if (this.data == 1) {
            return;
        }
        this.spawnItem(world, pos, tile.getDropStack(new ItemStack((ItemLike)this)));
    }

    @Override
    @Deprecated
    public void m_6810_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_() && !world.m_5776_()) {
            BlockPos targetPos = this.data == 0 ? pos.m_7494_() : pos.m_7495_();
            TileAbstractSM bEntity = this.getTile(world, targetPos);
            if (this.data == 0 && bEntity != null && bEntity instanceof TileTransferGate) {
                TileTransferGate tile = (TileTransferGate)bEntity;
                this.spawnItem(world, pos, tile.getInputItem());
            }
            this.breakBlock((LevelAccessor)world, targetPos);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }
}

