/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.iblock.IFoodExpBlock;
import sweetmagic.api.iblock.IWaterBlock;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.block.base.BaseFaceBlock;
import sweetmagic.init.tile.menu.container.ContainerWoodChest;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileWoodChest;
import sweetmagic.util.FaceAABB;

public class WoodChest
extends BaseFaceBlock
implements EntityBlock,
IWaterBlock,
IFoodExpBlock {
    public final int data;
    private static final VoxelShape[] AABB = FaceAABB.create(0.0, 0.0, 8.0, 16.0, 16.0, 16.0);
    private static final VoxelShape[] WOOD_CHEST = FaceAABB.create(0.0, 0.0, 2.0, 16.0, 16.0, 16.0);
    private static final VoxelShape[] POST = FaceAABB.create(4.0, 0.0, 7.0, 12.0, 19.5, 14.0);
    private static final VoxelShape[] CABINET = FaceAABB.create(0.0, 0.0, 6.0, 16.0, 16.0, 16.0);

    public WoodChest(String name, int data) {
        super(name, WoodChest.setState(Material.f_76320_, SoundType.f_56736_, 0.5f, 8192.0f));
        this.data = data;
        this.m_49959_((BlockState)this.setState().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        BlockInit.BlockInfo.create(this, SweetMagicCore.smTab, name);
    }

    public WoodChest(String name, BlockBehaviour.Properties props) {
        super(name, props);
        this.data = 5;
    }

    public WoodChest(String name, BlockBehaviour.Properties props, int data) {
        super(name, props);
        this.data = data;
    }

    @Override
    public boolean canRightClick(Player player, ItemStack stack) {
        return true;
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        if (world.m_5776_()) {
            return true;
        }
        TileWoodChest tile = (TileWoodChest)this.getTile(TileWoodChest::new, world, pos);
        if (player.m_7500_() && stack.m_150930_(ItemInit.creative_wand)) {
            this.openGUI(world, pos, player, new ContainerWoodChest(pos));
            return true;
        }
        if (tile.lootTable != null) {
            if (player.m_5833_()) {
                return false;
            }
            tile.setLootInv(player);
        }
        this.openGUI(world, pos, player, tile);
        SoundEvent sound = null;
        switch (this.data) {
            case 0: 
            case 5: 
            case 7: {
                sound = SoundEvents.f_12311_;
                break;
            }
            case 1: {
                sound = SoundEvents.f_11725_;
                break;
            }
            case 2: {
                sound = SoundEvents.f_12056_;
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                sound = SoundEvents.f_12629_;
                break;
            }
            case 8: {
                sound = SoundEvents.f_12088_;
            }
        }
        this.playerSound(world, pos, sound, 0.5f, world.m_213780_().m_188501_() * 0.1f + 0.9f);
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext con) {
        return switch (this.data) {
            case 0 -> FaceAABB.getAABB(AABB, state);
            case 4 -> FaceAABB.getAABB(WOOD_CHEST, state);
            case 9 -> FaceAABB.getAABB(POST, state);
            case 10 -> FaceAABB.getAABB(POST, state);
            case 11 -> FaceAABB.getAABB(CABINET, state);
            default -> Shapes.m_83144_();
        };
    }

    @Override
    protected boolean isDrop() {
        return false;
    }

    @Override
    public boolean isKeepTile() {
        return true;
    }

    public ItemStack getDropStack(TileAbstractSM tile) {
        return tile.getDropStack(new ItemStack((ItemLike)this));
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        toolTip.add((Component)this.getText("sm_chest").m_130940_(GREEN));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileWoodChest(pos, state);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> build) {
        build.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction face, BlockState newState, LevelAccessor world, BlockPos pos1, BlockPos pos2) {
        this.setWater(world, state, pos1);
        return super.m_7417_(state, face, newState, world, pos1, pos2);
    }

    public boolean m_7357_(BlockState state, BlockGetter get, BlockPos pos, PathComputationType type) {
        return type == PathComputationType.WATER ? get.m_6425_(pos).m_205070_(FluidTags.f_13131_) : false;
    }

    @Override
    public boolean isChanceUp() {
        return this.data == 4 || this.data == 7;
    }
}

