/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.ai;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import sweetmagic.init.entity.monster.BlazeTempest;
import sweetmagic.init.entity.projectile.CycloneMagicShot;

public class BlazeAttackGoal
extends Goal {
    public final Mob blaze;
    public int attackStep;
    public int attackTime;
    public int lastSeen;
    public final int data;
    public boolean isHard;

    public BlazeAttackGoal(Mob blaze, boolean isHard, int data) {
        this.blaze = blaze;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.data = data;
        this.isHard = isHard;
    }

    public boolean m_8036_() {
        LivingEntity entity = this.blaze.m_5448_();
        return entity != null && entity.m_6084_() && this.blaze.m_6779_(entity);
    }

    public void m_8056_() {
        this.attackStep = 0;
    }

    public void m_8041_() {
        this.lastSeen = 0;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        --this.attackTime;
        LivingEntity target = this.blaze.m_5448_();
        if (target == null) {
            return;
        }
        boolean flag = this.blaze.m_21574_().m_148306_((Entity)target);
        this.lastSeen = flag ? 0 : (this.lastSeen = this.lastSeen + 1);
        double d0 = this.blaze.m_20280_((Entity)target);
        if (d0 < 4.0) {
            if (!flag) {
                return;
            }
            if (this.attackTime <= 0) {
                this.attackTime = 20;
                this.blaze.m_7327_((Entity)target);
            }
            this.blaze.m_21566_().m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 1.0);
        } else if (d0 < this.getFollowDistance() * this.getFollowDistance() && flag) {
            Level world = this.blaze.m_9236_();
            double x = target.m_20185_() - this.blaze.m_20185_();
            double y = target.m_20227_(0.3333333333333333) - this.blaze.m_20186_();
            double z = target.m_20189_() - this.blaze.m_20189_();
            double xz = Math.sqrt(x * x + z * z);
            if (this.attackTime <= 0) {
                ++this.attackStep;
                if (this.attackStep == 1) {
                    this.attackTime = 40;
                } else if (this.attackStep <= 5) {
                    this.attackTime = 6;
                } else {
                    this.attackTime = 140;
                    this.attackStep = 0;
                }
                if (this.attackStep > 1) {
                    boolean isWarden;
                    if (!this.blaze.m_20067_()) {
                        world.m_5898_((Player)null, 1018, this.blaze.m_20183_(), 0);
                    }
                    float shake = (isWarden = target instanceof Warden) ? 6.0f : 48.0f;
                    int range = isWarden ? 30 : 16;
                    float dama = isWarden ? 8.0f : 1.5f;
                    float speed = isWarden ? 2.25f : 1.0f;
                    int attackCount = isWarden ? 8 : 3;
                    this.blaze.m_5496_(SoundEvents.f_11705_, 0.5f, 0.67f);
                    if (this.data == 0) {
                        dama = isWarden ? 5.0f : 0.5f;
                        speed = isWarden ? 2.25f : 1.25f;
                        int n = attackCount = isWarden ? 5 : 1 + (int)Math.min(3.0f, 3.0f * ((BlazeTempest)this.blaze).getDateRate(world, 0.25f));
                    }
                    if (!isWarden && this.isHard) {
                        dama += this.data == 0 ? 0.75f : 1.0f;
                    }
                    for (int i = 0; i < attackCount; ++i) {
                        CycloneMagicShot entity = new CycloneMagicShot(world, (LivingEntity)this.blaze);
                        entity.m_6686_(x, y - xz * (double)0.065f, z, speed, shake);
                        entity.setAddDamage(entity.getAddDamage() + dama);
                        entity.setRange(1.0);
                        entity.setMaxLifeTime(range);
                        world.m_7967_((Entity)entity);
                    }
                }
            }
            this.blaze.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
        } else if (this.lastSeen < 5) {
            this.blaze.m_21566_().m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 1.0);
        }
        super.m_8037_();
    }

    public double getFollowDistance() {
        return this.blaze.m_21133_(Attributes.f_22277_);
    }
}

