/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.animal;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GolemRandomStrollInVillageGoal;
import net.minecraft.world.entity.ai.goal.JumpGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.animal.AbstractSummonMob;
import sweetmagic.init.entity.projectile.AbstractMagicShot;
import sweetmagic.init.entity.projectile.CherryMagicShot;
import sweetmagic.init.entity.projectile.SoulBlazeShot;
import sweetmagic.util.PlayerHelper;
import sweetmagic.util.SMDamage;

public class WitchFox
extends AbstractSummonMob {
    private int recastTime = 100;
    protected int magicTime = 150;
    protected int fireTime = 200;
    private float crouchAmount;
    private float crouchAmountO;
    private float interestedAngle;
    private float interestedAngleO;
    private static final EntityDataAccessor<Boolean> POUNCE = ISMMob.setData(WitchFox.class, ISMMob.BOOLEAN);
    private static final EntityDataAccessor<Boolean> CROUCH = ISMMob.setData(WitchFox.class, ISMMob.BOOLEAN);
    private static final EntityDataAccessor<Boolean> INTEREST = ISMMob.setData(WitchFox.class, ISMMob.BOOLEAN);
    private static final EntityDataAccessor<Integer> FIRE_COUNT = ISMMob.setData(WitchFox.class, ISMMob.INT);

    public WitchFox(Level world) {
        this(EntityInit.witchFox, world);
    }

    public WitchFox(EntityType<? extends AbstractSummonMob> eType, Level world) {
        super(eType, world);
        this.f_21342_ = new FoxMoveControl();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(POUNCE, false);
        this.define(CROUCH, false);
        this.define(INTEREST, false);
        this.define(FIRE_COUNT, 0);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22284_, 0.25).m_22268_(Attributes.f_22277_, 48.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new FoxPounceGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new GolemRandomStrollInVillageGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f, false){

            public boolean m_8036_() {
                return !WitchFox.this.getPounce() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Monster.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new AbstractSummonMob.SMOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new AbstractSummonMob.SMOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, new AbstractSummonMob.NearestAttackSMMobGoal<Monster>(this, Monster.class, false));
        this.f_21346_.m_25352_(5, new AbstractSummonMob.AttackTargetGoal<Raider>(this, Raider.class, false));
        this.f_21346_.m_25352_(6, new AbstractSummonMob.AttackTargetGoal<Warden>(this, Warden.class, false));
        this.f_21346_.m_25352_(7, new AbstractSummonMob.AttackTargetGoal<Slime>(this, Slime.class, false));
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11944_;
    }

    protected SoundEvent m_7975_(DamageSource src) {
        return SoundEvents.f_11948_;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public boolean getPounce() {
        return this.get(POUNCE);
    }

    public void setPounce(boolean pounce) {
        this.set(POUNCE, pounce);
    }

    public boolean m_6047_() {
        return this.get(CROUCH);
    }

    public void setCrouch(boolean crouch) {
        this.set(CROUCH, crouch);
    }

    public boolean isInterest() {
        return this.get(INTEREST);
    }

    public void setIsInterest(boolean interest) {
        this.set(INTEREST, interest);
    }

    public int getFireCount() {
        return this.get(FIRE_COUNT);
    }

    public void setFireCount(int fireCount) {
        this.set(FIRE_COUNT, fireCount);
    }

    public boolean isFullyCrouched() {
        return this.crouchAmount == 3.0f;
    }

    public float getCrouchAmount(float par1) {
        return Mth.m_14179_((float)par1, (float)this.crouchAmountO, (float)this.crouchAmount);
    }

    public float getHeadRollAngle(float angle) {
        return Mth.m_14179_((float)angle, (float)this.interestedAngleO, (float)this.interestedAngle) * 0.11f * (float)Math.PI;
    }

    public boolean isJumping() {
        return this.f_20899_;
    }

    public boolean canMove() {
        return !this.getShit() && !this.getPounce();
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128405_("fireCount", this.getFireCount());
        tags.m_128405_("recastTime", this.recastTime);
        tags.m_128405_("magicTime", this.magicTime);
        tags.m_128405_("fireTime", this.fireTime);
        tags.m_128379_("Pounce", this.getPounce());
        tags.m_128379_("Crouching", this.m_6047_());
        tags.m_128379_("Interest", this.isInterest());
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.setFireCount(tags.m_128451_("fireCount"));
        this.recastTime = tags.m_128451_("recastTime");
        this.magicTime = tags.m_128451_("magicTime");
        this.fireTime = tags.m_128451_("fireCount");
        this.setPounce(tags.m_128471_("Pounce"));
        this.setCrouch(tags.m_128471_("Crouching"));
        this.setIsInterest(tags.m_128471_("Interest"));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_6084_()) {
            return;
        }
        this.interestedAngleO = this.interestedAngle;
        this.interestedAngle += this.isInterest() ? (1.0f - this.interestedAngle) * 0.4f : (0.0f - this.interestedAngle) * 0.4f;
        this.crouchAmountO = this.crouchAmount;
        if (this.m_6047_()) {
            this.crouchAmount += 0.2f;
            if (this.crouchAmount > 3.0f) {
                this.crouchAmount = 3.0f;
            }
        } else {
            this.crouchAmount = 0.0f;
        }
        if (this.f_19797_ % 20 == 0 && this.isClient()) {
            int count = Math.min(10, this.getFireCount());
            for (int i = 0; i < count; ++i) {
                float f1 = (float)this.m_20185_() + this.getRand(1.5f);
                float f2 = (float)this.m_20186_() + 0.25f + this.getRand();
                float f3 = (float)this.m_20189_() + this.getRand(1.5f);
                float x = this.getRand(0.025f);
                float y = this.getRand(0.025f);
                float z = this.getRand(0.025f);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, (double)f1, (double)f2, (double)f3, (double)x, (double)y, (double)z);
            }
        }
        if (this.f_19797_ % 10 != 0 || this.isClient() || this.getFireCount() >= 16) {
            return;
        }
        List<Mob> entityList = this.getEntityList(Mob.class, 24.0).stream().filter(t -> !t.m_6084_() && !t.getPersistentData().m_128441_("dead_" + this.m_20148_())).toList();
        if (!entityList.isEmpty()) {
            this.setFireCount(Math.min(16, this.getFireCount() + entityList.size()));
            entityList.forEach(e -> e.getPersistentData().m_128379_("dead_" + this.m_20148_(), true));
        }
        if (this.getFireCount() > 0 && this.m_21223_() <= this.m_21233_() * 0.5f) {
            int count = Math.min(5, this.getFireCount());
            this.m_5634_((float)count * 0.1f * this.m_21233_());
            this.setFireCount(this.getFireCount() - count);
        }
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        if (target == null || !target.m_6084_()) {
            this.setCrouch(false);
            this.setIsInterest(false);
            this.setPounce(false);
            this.m_6710_(null);
            return;
        }
        this.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
        if (this.getShit() || this.getPounce()) {
            return;
        }
        if (this.magicTime-- <= 0) {
            this.magicShot(target, this.cherryShot());
        }
        if (this.getFireCount() > 0 && this.fireTime-- <= 0) {
            this.magicShot(target, this.fireShot());
        }
    }

    public void magicShot(LivingEntity target, AbstractMagicShot entity) {
        int level;
        boolean isWarden = target instanceof Warden;
        float dama = this.getPower(this.getWandLevel()) + (float)this.m_21133_(Attributes.f_22281_) * 0.35f;
        float dameRate = isWarden ? 4.0f : 1.0f;
        double x = target.m_20185_() - this.m_20185_();
        double y = target.m_20227_(0.3333333333333333) - this.m_20186_();
        double z = target.m_20189_() - this.m_20189_();
        double xz = Math.sqrt(x * x + z * z);
        int n = level = isWarden ? this.getWandLevel() + 20 : this.getWandLevel();
        if (!isWarden && this.isBoss((Entity)target)) {
            dama /= 5.0f;
        }
        entity.setWandLevel(level);
        entity.m_6686_(x, y - xz * 0.035, z, 2.25f, 0.0f);
        entity.setAddDamage((entity.getAddDamage() + dama) * dameRate);
        this.m_5496_(SoundEvents.f_11705_, 0.5f, 0.67f);
        this.m_9236_().m_7967_((Entity)entity);
    }

    public AbstractMagicShot cherryShot() {
        this.magicTime = 125 + this.rand.nextInt(75);
        CherryMagicShot entity = new CherryMagicShot(this.m_9236_(), (LivingEntity)this);
        entity.setData(2);
        entity.setRange(2.5 + (double)this.getRange());
        return entity;
    }

    public AbstractMagicShot fireShot() {
        this.fireTime = 225 + this.rand.nextInt(75);
        SoulBlazeShot entity = new SoulBlazeShot(this.m_9236_(), (LivingEntity)this);
        entity.setRange(6.5 + (double)this.getRange());
        entity.setAddAttack(this.getFireCount());
        return entity;
    }

    protected float getStandingEyeHeight(PoseStack.Pose pose, EntityDimensions dim) {
        return dim.f_20378_ * 0.8f;
    }

    public int m_8132_() {
        return this.m_21825_() ? 20 : super.m_8132_();
    }

    public boolean isPathClear(WitchFox fox, LivingEntity target) {
        double d0 = target.m_20189_() - fox.m_20189_();
        double d1 = target.m_20185_() - fox.m_20185_();
        double d2 = d0 / d1;
        for (int i = 0; i < 6; ++i) {
            double d3 = d2 == 0.0 ? 0.0 : d0 * (double)((float)i / 6.0f);
            double d4 = d2 == 0.0 ? d1 * (double)((float)i / 6.0f) : d3 / d2;
            for (int k = 1; k < 4; ++k) {
                if (fox.m_9236_().m_8055_(new BlockPos(fox.m_20185_() + d4, fox.m_20186_() + (double)k, fox.m_20189_() + d3)).m_60767_().m_76336_()) continue;
                return false;
            }
        }
        return true;
    }

    public class FoxMoveControl
    extends MoveControl {
        public FoxMoveControl() {
            super((Mob)WitchFox.this);
        }

        public void m_8126_() {
            if (WitchFox.this.canMove()) {
                super.m_8126_();
            }
        }
    }

    public class FoxPounceGoal
    extends JumpGoal {
        private final WitchFox fox;
        private BlockPos pos;

        public FoxPounceGoal(WitchFox fox) {
            this.fox = fox;
        }

        public boolean m_8036_() {
            LivingEntity target = this.fox.m_5448_();
            if (target != null && target.m_6084_()) {
                if (this.fox.recastTime <= 60 && !this.fox.getShit()) {
                    this.fox.setCrouch(true);
                    this.fox.setPounce(true);
                    this.fox.setIsInterest(false);
                }
                return this.fox.recastTime-- <= 1;
            }
            return false;
        }

        public boolean m_6767_() {
            return false;
        }

        public void m_8056_() {
            this.fox.m_6862_(true);
            LivingEntity target = this.fox.m_5448_();
            if (target != null) {
                this.pos = this.fox.m_20183_();
                this.fox.m_6021_(target.m_20185_(), target.m_20186_() + 6.0, target.m_20189_());
            }
            this.fox.m_21573_().m_26573_();
        }

        public void m_8041_() {
            this.fox.recastTime = 120 + this.fox.rand.nextInt(75);
            this.fox.setCrouch(false);
            this.fox.crouchAmount = 0.0f;
            this.fox.crouchAmountO = 0.0f;
            this.fox.setIsInterest(false);
            this.fox.setPounce(false);
        }

        public void m_8037_() {
            Vec3 vec3 = this.fox.m_20184_();
            if (vec3.f_82480_ * vec3.f_82480_ < (double)0.03f && this.fox.m_146909_() != 0.0f) {
                this.fox.m_146926_(Mth.m_14201_((float)this.fox.m_146909_(), (float)0.0f, (float)0.2f));
            } else {
                double d0 = vec3.m_165924_();
                double d1 = Math.signum(-vec3.f_82480_) * Math.acos(d0 / vec3.m_82553_()) * 180.0 / Math.PI;
                this.fox.m_146926_((float)d1);
            }
            LivingEntity target = this.fox.m_5448_();
            if (target != null && this.fox.m_20096_() && this.fox.recastTime < 0 || this.fox.m_20270_((Entity)target) <= 2.0f) {
                this.targetAttack(target);
                this.fox.m_6021_((double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 1.5, (double)this.pos.m_123343_() + 0.5);
            }
        }

        public void targetAttack(LivingEntity target) {
            this.m_8041_();
            double range = 2.0 + (double)this.fox.getRange();
            float damage = this.fox.getPower(this.fox.getWandLevel()) + (float)this.fox.m_21133_(Attributes.f_22281_) * 0.67f;
            List<Mob> entityList = this.fox.getEntityList(Mob.class, this.fox.isTarget(), range);
            entityList.forEach(e -> this.attackDamage((Mob)e, (Entity)this.fox, (Entity)this.fox, damage));
            this.fox.m_5496_(SoundEvents.f_11874_, 0.5f, 1.0f);
            Level level = this.fox.f_19853_;
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel server = (ServerLevel)level;
            double ySpeed = -0.25;
            double yRate = -0.6;
            double inRate = 0.25;
            BlockPos pos = this.fox.m_20183_();
            for (int i = 0; i < 4; ++i) {
                this.spawnParticleRing(server, (ParticleOptions)ParticleInit.GRAVITY, range * (1.0 - 0.14 * (double)i), pos.m_6630_(i + 1), ySpeed + (double)i * yRate, inRate);
            }
        }

        protected void spawnParticleRing(ServerLevel server, ParticleOptions par, double range, BlockPos pos, double ySpeed, double moveValue) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.5;
            double z = (double)pos.m_123343_() + 0.5;
            for (double degree = 0.0; degree < range * Math.PI; degree += 0.1) {
                double rate = range;
                server.m_8767_(par, x + Math.cos(degree) * rate, y, z + Math.sin(degree) * rate, 0, -Math.cos(degree), ySpeed, -Math.sin(degree), moveValue);
            }
        }

        public void attackDamage(Mob target, Entity attacker, Entity magic, float damage) {
            target.f_19802_ = 0;
            if (!(target instanceof EnderMan) && !(target instanceof Witch)) {
                target.m_6469_(SMDamage.getMagicDamage(magic, attacker), target instanceof Warden ? damage * 5.0f : damage);
            } else if (attacker instanceof Player) {
                Player payer = (Player)attacker;
                target.m_6469_(DamageSource.m_19344_((Player)payer), damage);
            }
            target.f_19802_ = 0;
            PlayerHelper.setPotion((LivingEntity)target, PotionInit.gravity, 3, 100);
            Vec3 vec3 = new Vec3(target.m_20185_() - this.fox.m_20185_(), (target.m_20186_() - this.fox.m_20186_()) * 1.0, target.m_20189_() - this.fox.m_20189_()).m_82490_(-0.25);
            target.m_20256_(target.m_20184_().m_82549_(vec3));
            target.f_19789_ = (float)((double)target.f_19789_ + 0.5);
        }
    }
}

