/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.animal;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.api.ientity.IWolf;
import sweetmagic.init.EntityInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.animal.AbstractSummonMob;
import sweetmagic.util.SMDamage;

public class WitchWolf
extends AbstractSummonMob
implements IWolf {
    private boolean isWet;
    private boolean isShaking;
    private float shakeAnim;
    private float shakeAnimO;
    private float interestedAngle;
    private float interestedAngleO;
    private int recastTime = 0;
    public AnimationState summonAnim = new AnimationState();
    private static final EntityDataAccessor<Integer> ATTACK_TICK = ISMMob.setData(WitchWolf.class, ISMMob.INT);

    public WitchWolf(Level world) {
        super(EntityInit.witchWolf, world);
    }

    public WitchWolf(EntityType<? extends AbstractSummonMob> eType, Level world) {
        super(eType, world);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(ATTACK_TICK, 0);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22284_, 0.1).m_22268_(Attributes.f_22277_, 48.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(5, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(6, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new AbstractSummonMob.SMOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new AbstractSummonMob.SMOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, new AbstractSummonMob.NearestAttackSMMobGoal<Monster>(this, Monster.class, false));
        this.f_21346_.m_25352_(5, new AbstractSummonMob.AttackTargetGoal<Raider>(this, Raider.class, false));
        this.f_21346_.m_25352_(6, new AbstractSummonMob.AttackTargetGoal<Warden>(this, Warden.class, false));
        this.f_21346_.m_25352_(7, new AbstractSummonMob.AttackTargetGoal<AbstractSkeleton>(this, AbstractSkeleton.class, false));
        this.f_21346_.m_25352_(8, new AbstractSummonMob.AttackTargetGoal<Slime>(this, Slime.class, false));
    }

    protected SoundEvent m_7515_() {
        if (this.rand.nextInt(3) == 0) {
            return this.m_21824_() && this.m_21223_() < 10.0f ? SoundEvents.f_12625_ : SoundEvents.f_12622_;
        }
        return SoundEvents.f_12617_;
    }

    protected SoundEvent m_7975_(DamageSource src) {
        return SoundEvents.f_12621_;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public void m_7822_(byte par1) {
        switch (par1) {
            case 4: {
                this.summonAnim.m_216973_();
                break;
            }
            case 5: {
                this.summonAnim.m_216977_(this.f_19797_);
                break;
            }
            default: {
                super.m_7822_(par1);
            }
        }
    }

    public void setAttackTick(int attackTick) {
        this.set(ATTACK_TICK, attackTick);
    }

    @Override
    public int getAttackTick() {
        return this.get(ATTACK_TICK);
    }

    @Override
    public void hurtAction(Entity attacker, float amount) {
        if (this.getGolem()) {
            boolean isBoss;
            DamageSource src = SMDamage.getAddDamage((Entity)this, (Entity)this);
            if (attacker instanceof EnderMan || attacker instanceof Witch) {
                src = DamageSource.m_19344_((Player)((Player)this.m_21826_()));
            }
            amount = (isBoss = this.isBoss(attacker)) ? Math.min(1.0f, amount) : Math.min(5.0f, amount);
            attacker.m_6469_(src, isBoss ? amount * 0.05f : amount * 0.25f);
            attacker.f_19802_ = 0;
        }
    }

    @Override
    public boolean m_7327_(Entity entity) {
        this.setAttackTick(this.f_19797_);
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (this.getMaster()) {
                this.addAttack(target);
                this.addPotion(target, PotionInit.debuff_extension, 600, 0);
            }
            if (this.getIfrit()) {
                this.addAttack(target);
                this.addPotion(target, PotionInit.flame, 600, 0);
            }
            if (this.getWindine()) {
                this.addAttack(target);
                this.addPotion(target, PotionInit.frost, 600, 0);
            }
        }
        return super.m_7327_(entity);
    }

    public void addAttack(LivingEntity target) {
        float damage = (float)this.m_21133_(Attributes.f_22281_);
        target.m_6469_(SMDamage.getAddDamage((Entity)this, (Entity)this), damage);
        target.f_19802_ = 0;
    }

    public void m_8107_() {
        int attackTick;
        super.m_8107_();
        if (!this.isClient() && this.isWet && !this.isShaking && !this.m_21691_() && this.f_19861_) {
            this.isShaking = true;
            this.shakeAnim = 0.0f;
            this.shakeAnimO = 0.0f;
            this.m_9236_().m_7605_((Entity)this, (byte)8);
        }
        if (!this.isClient() && this.m_6084_() && this.f_19797_ % 20 == 0 && this.getAlay()) {
            this.m_5634_(1.0f);
        }
        if (this.f_19797_ > (attackTick = this.getAttackTick()) + 10) {
            this.setAttackTick(0);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_6084_()) {
            return;
        }
        this.interestedAngleO = this.interestedAngle;
        if (this.m_20071_()) {
            this.isWet = true;
            if (this.isShaking && !this.isClient()) {
                this.m_9236_().m_7605_((Entity)this, (byte)56);
            }
        } else if ((this.isWet || this.isShaking) && this.isShaking) {
            if (this.shakeAnim == 0.0f) {
                this.m_5496_(SoundEvents.f_12623_, this.m_6121_(), this.getRand(0.2f) + 1.0f);
                this.m_146850_(GameEvent.f_223710_);
            }
            this.shakeAnimO = this.shakeAnim;
            this.shakeAnim += 0.05f;
            if (this.shakeAnimO >= 2.0f) {
                this.isWet = false;
                this.isShaking = false;
                this.shakeAnimO = 0.0f;
                this.shakeAnim = 0.0f;
            }
            if (this.shakeAnim > 0.4f) {
                float f = (float)this.m_20186_();
                int i = (int)(Mth.m_14031_((float)((this.shakeAnim - 0.4f) * (float)Math.PI)) * 7.0f);
                Vec3 vec3 = this.m_20184_();
                for (int j = 0; j < i; ++j) {
                    float f1 = (this.getRand() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                    float f2 = (this.getRand() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() + (double)f1, (double)(f + 0.8f), this.m_20189_() + (double)f2, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                }
            }
        }
    }

    @Override
    protected void m_8024_() {
        LivingEntity target;
        super.m_8024_();
        if (this.recastTime > 0) {
            --this.recastTime;
        }
        if (this.f_19797_ == 1) {
            this.m_9236_().m_7605_((Entity)this, (byte)5);
        }
        if ((target = this.m_5448_()) == null || !target.m_6084_() || this.recastTime > 0 || this.getShit()) {
            return;
        }
        if ((double)this.m_20270_((Entity)target) > 4.0 && this.teleportTowards((Entity)target)) {
            this.recastTime += 2400;
        }
    }

    public boolean teleportTowards(Entity entity) {
        Vec3 vec3 = new Vec3(this.m_20185_() - entity.m_20185_(), this.m_20227_(0.5) - entity.m_20188_(), this.m_20189_() - entity.m_20189_());
        vec3 = vec3.m_82541_();
        double d1 = entity.m_20185_() + (double)this.getRand(4.0f);
        double d2 = entity.m_20186_() + (double)this.getRand(4.0f);
        double d3 = entity.m_20189_() + (double)this.getRand(4.0f);
        return this.teleport(d1, d2, d3);
    }

    private boolean teleport(double x, double y, double z) {
        BlockPos.MutableBlockPos muPos = new BlockPos.MutableBlockPos(x, y, z);
        while (muPos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)muPos).m_60767_().m_76334_()) {
            muPos.m_122173_(Direction.DOWN);
        }
        BlockState state = this.m_9236_().m_8055_((BlockPos)muPos);
        boolean flag = state.m_60767_().m_76334_();
        boolean flag1 = state.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)x, (double)y, (double)z);
            if (event.isCanceled()) {
                return false;
            }
            Vec3 vec3 = this.m_20182_();
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2) {
                this.m_9236_().m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)this));
                if (!this.m_20067_()) {
                    this.m_9236_().m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                    this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                }
            }
            return flag2;
        }
        return false;
    }

    public void m_6667_(DamageSource src) {
        this.isWet = false;
        this.isShaking = false;
        this.shakeAnimO = 0.0f;
        this.shakeAnim = 0.0f;
        super.m_6667_(src);
    }

    public boolean isWet() {
        return this.isWet;
    }

    public float getWetShade(float par1) {
        return Math.min(0.5f + Mth.m_14179_((float)par1, (float)this.shakeAnimO, (float)this.shakeAnim) / 2.0f * 0.5f, 1.0f);
    }

    public float getBodyRollAngle(float par1, float par2) {
        float f = (Mth.m_14179_((float)par1, (float)this.shakeAnimO, (float)this.shakeAnim) + par2) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return Mth.m_14031_((float)(f * (float)Math.PI)) * Mth.m_14031_((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    public float getHeadRollAngle(float angle) {
        return Mth.m_14179_((float)angle, (float)this.interestedAngleO, (float)this.interestedAngle) * 0.15f * (float)Math.PI;
    }

    protected float getStandingEyeHeight(PoseStack.Pose pose, EntityDimensions dim) {
        return dim.f_20378_ * 0.8f;
    }

    public int m_8132_() {
        return this.m_21825_() ? 20 : super.m_8132_();
    }
}

