/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.PotionInit;

public class ArchSpider
extends Spider
implements ISMMob {
    public ArchSpider(Level world) {
        super(EntityInit.archSpider, world);
    }

    public ArchSpider(EntityType<? extends Spider> enType, Level world) {
        super(enType, world);
        this.f_21364_ = 35;
    }

    @Override
    public void refreshInfo() {
        this.m_20090_();
        this.m_6210_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(4, (Goal)new SpiderAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22278_, 4.0).m_22268_(Attributes.f_22277_, 24.0);
    }

    @Override
    public SynchedEntityData getData() {
        return this.m_20088_();
    }

    public EntityDimensions m_6972_(Pose pose) {
        float rate = 1.0f + 0.375f * (float)this.getPotionLevel((LivingEntity)this, PotionInit.leader_flag);
        return super.m_6972_(pose).m_20388_(rate);
    }

    public boolean m_6469_(DamageSource src, float amount) {
        Entity attacker = src.m_7639_();
        if (attacker != null && attacker instanceof ISMMob) {
            return false;
        }
        amount = this.getDamageAmount(this.m_9236_(), src, amount, 1.0f);
        return super.m_6469_(src, amount);
    }

    public void m_8119_() {
        super.m_8119_();
        this.f_19789_ = 0.0f;
    }

    public boolean m_7327_(Entity target) {
        if (!super.m_7327_(target)) {
            return false;
        }
        if (!(target instanceof LivingEntity)) {
            return true;
        }
        LivingEntity living = (LivingEntity)target;
        int time = 6;
        int level = 0;
        if (target instanceof Warden) {
            time = 360;
            level = 4;
        } else {
            time = (int)((float)time * (20.0f * this.getDateRate(this.m_9236_(), 0.1f)));
        }
        this.addPotion(living, PotionInit.deadly_poison, time, level);
        living.f_19802_ = 0;
        return true;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance dif, MobSpawnType spawn, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        data = super.m_6518_(world, dif, spawn, data, tag);
        this.initMobData((LivingEntity)this, dif);
        return data;
    }

    public static class SpiderAttackGoal
    extends MeleeAttackGoal {
        public SpiderAttackGoal(Spider entity) {
            super((PathfinderMob)entity, 1.0, true);
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.f_25540_.m_20160_();
        }

        public boolean m_8045_() {
            float f = this.f_25540_.m_213856_();
            if (f >= 0.5f && this.f_25540_.m_217043_().m_188503_(100) == 0) {
                this.f_25540_.m_6710_((LivingEntity)null);
                return false;
            }
            return super.m_8045_();
        }

        protected double m_6639_(LivingEntity entity) {
            return 4.0f + entity.m_20205_();
        }
    }
}

