/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster;

import com.mojang.math.Vector3f;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.api.ientity.IWitch;
import sweetmagic.init.EntityInit;
import sweetmagic.init.entity.monster.AbstractSMMob;
import sweetmagic.init.entity.projectile.AbstractMagicShot;
import sweetmagic.init.entity.projectile.BloodMagicShot;
import sweetmagic.init.entity.projectile.ElectricMagicShot;
import sweetmagic.init.entity.projectile.ExplosionMagicShot;
import sweetmagic.init.entity.projectile.GravityMagicShot;

public class BlitzWizard
extends AbstractSMMob
implements IWitch {
    private int recastTime = 0;
    private static final int RAND_RECASTTIME = 60;
    public AnimationState magicAttackAnim = new AnimationState();
    private static final EntityDataAccessor<Boolean> TARGET = SynchedEntityData.m_135353_(BlitzWizard.class, (EntityDataSerializer)BOOLEAN);

    public BlitzWizard(Level world) {
        super(EntityInit.blitzWizard, world);
    }

    public BlitzWizard(EntityType<BlitzWizard> enType, Level world) {
        super(enType, world);
        this.f_21364_ = 150;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.define(TARGET, false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Warden.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12548_;
    }

    protected SoundEvent m_7975_(DamageSource src) {
        return SoundEvents.f_12552_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12550_;
    }

    public void setTarget(boolean isTarget) {
        this.set(TARGET, isTarget);
    }

    @Override
    public boolean isTarget() {
        return (Boolean)this.get(TARGET);
    }

    @Override
    public AnimationState getAnimaState() {
        return this.magicAttackAnim;
    }

    @Override
    public boolean isCharge() {
        return false;
    }

    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128379_("is_target", this.isTarget());
    }

    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.set(TARGET, tags.m_128471_("is_target"));
    }

    public boolean m_6469_(DamageSource src, float amount) {
        Entity attacker = src.m_7639_();
        Entity attackEntity = src.m_7640_();
        if (attacker != null && attacker instanceof ISMMob) {
            return false;
        }
        if (this.notMagicDamage(attacker, attackEntity)) {
            amount *= 0.25f;
        }
        if (!this.isLeader((LivingEntity)this)) {
            amount = this.getBossDamageAmount(this.m_9236_(), this.defTime, src, amount, 20.0f);
            this.defTime = 1;
        }
        return super.m_6469_(src, amount);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.isClient() && this.f_19797_ % 10 == 0) {
            this.set(TARGET, this.m_5448_() != null);
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return;
        }
        this.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
        if (this.recastTime-- > 0) {
            return;
        }
        this.recastTime = this.rand.nextInt(60) + 60;
        int randValue = this.rand.nextInt(4);
        boolean isWarden = target instanceof Warden;
        float dama = isWarden ? 45.0f : 5.0f;
        int level = isWarden ? 36 : 10;
        for (int i = 0; i < 3; ++i) {
            AbstractMagicShot entity = this.getMagicShot(target, randValue);
            double d0 = target.m_20185_() - this.m_20185_();
            double d1 = target.m_20189_() - this.m_20189_();
            double d3 = target.m_20227_(0.3333333333333333) - this.m_20186_() - 1.0;
            Vector3f vec = this.getShotVector((Mob)this, new Vec3(d0, d3, d1), -20.0f + (float)i * 20.0f);
            entity.m_6686_(vec.m_122239_(), vec.m_122260_(), vec.m_122269_(), randValue == 2 ? 1.0f : 1.75f, 1.0f);
            entity.setHitDead(false);
            entity.setData(1);
            entity.setWandLevel(level);
            entity.setAddDamage(entity.getAddDamage() + dama);
            entity.setRange(2.0);
            this.addEntity((Entity)entity);
        }
        this.m_5496_(SoundEvents.f_11705_, 0.5f, 0.67f);
    }

    public AbstractMagicShot getMagicShot(LivingEntity target, int randValue) {
        AbstractMagicShot entity = null;
        switch (randValue) {
            case 1: {
                entity = new BloodMagicShot(this.m_9236_(), (LivingEntity)this);
                break;
            }
            case 2: {
                entity = new ElectricMagicShot(this.m_9236_(), (LivingEntity)this);
                ((ElectricMagicShot)entity).isRangeAttack = true;
                break;
            }
            case 3: {
                entity = new ExplosionMagicShot(this.m_9236_(), (LivingEntity)this);
                break;
            }
            default: {
                entity = new GravityMagicShot(this.m_9236_(), (LivingEntity)this);
            }
        }
        return entity;
    }

    @Override
    public boolean isLowRank() {
        return false;
    }
}

