/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.entity.monster.AbstractSMMob;
import sweetmagic.init.entity.projectile.AbstractMagicShot;
import sweetmagic.init.entity.projectile.CalamityBomb;

public class CreeperCalamity
extends AbstractSMMob {
    private int recastTime = 0;
    private static final int RAND_RECASTTIME = 40;

    public CreeperCalamity(Level world) {
        super(EntityInit.creeperCalamity, world);
    }

    public CreeperCalamity(EntityType<? extends CreeperCalamity> enType, Level world) {
        super(enType, world);
        this.f_21364_ = 35;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Warden.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22277_, 20.0);
    }

    protected SoundEvent m_7975_(DamageSource src) {
        return SoundEvents.f_11836_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11835_;
    }

    public boolean m_6469_(DamageSource src, float amount) {
        Entity attacker = src.m_7639_();
        if (attacker != null && attacker instanceof ISMMob) {
            return false;
        }
        amount = this.getDamageAmount(this.m_9236_(), src, amount, 0.25f);
        if (!this.isClient() && !src.m_19387_() && this.recastTime > 0) {
            this.recastTime = (int)((float)this.recastTime * 0.75f);
        }
        return super.m_6469_(src, amount);
    }

    protected void m_8024_() {
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return;
        }
        this.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
        if (this.recastTime-- > 0) {
            return;
        }
        boolean isWarden = target instanceof Warden;
        this.recastTime = (int)((float)(this.rand.nextInt(40) + 150) * (isWarden ? 0.15f : 1.0f));
        AbstractMagicShot entity = this.getMagicShot(target, isWarden);
        this.m_5496_(SoundEvents.f_11705_, 0.5f, 0.67f);
        this.addEntity((Entity)entity);
    }

    public AbstractMagicShot getMagicShot(LivingEntity target, boolean isWarden) {
        CalamityBomb entity = new CalamityBomb((LivingEntity)this);
        float dameRate = isWarden ? 1.25f : this.getDateRate(this.m_9236_(), 0.4f);
        double x = target.m_20185_() - this.m_20185_();
        double y = target.m_20227_(0.3333333333333333) - this.m_20186_();
        double z = target.m_20189_() - this.m_20189_();
        double xz = Math.sqrt(x * x + z * z);
        float shotSpeed = this.m_20270_((Entity)target) * 0.075f;
        entity.m_6686_(x, y - xz * 0.035, z, shotSpeed, 0.0f);
        entity.setHitDead(false);
        entity.setNotDamage(true);
        entity.setRange(2.0);
        entity.setCount(2);
        entity.setAddDamage(entity.getAddDamage() + 1.0f * dameRate);
        return entity;
    }
}

