/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster;

import com.mojang.math.Vector3f;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.ientity.IGolem;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.entity.monster.AbstractSMMob;
import sweetmagic.init.entity.projectile.ElectricSphere;

public class ElectricGolem
extends AbstractSMMob
implements IGolem {
    private int recastTime = 0;
    private static final int RAND_RECASTTIME = 40;
    private static final EntityDataAccessor<Integer> ATTACK_TICK = ISMMob.setData(ElectricGolem.class, ISMMob.INT);

    public ElectricGolem(Level world) {
        super(EntityInit.electricGolem, world);
    }

    public ElectricGolem(EntityType<ElectricGolem> enType, Level world) {
        super(enType, world);
        this.f_21364_ = 200;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.define(ATTACK_TICK, 0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Warden.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22284_, 12.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected SoundEvent m_7975_(DamageSource src) {
        return SoundEvents.f_12008_;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12010_, 1.0f, 0.5f);
    }

    public void setAttackTick(int attackTick) {
        this.set(ATTACK_TICK, attackTick);
    }

    @Override
    public int getAttackTick() {
        return (Integer)this.get(ATTACK_TICK);
    }

    public boolean m_6469_(DamageSource src, float amount) {
        Entity attacker = src.m_7639_();
        Entity attackEntity = src.m_7640_();
        if (attacker != null && attacker instanceof ISMMob) {
            return false;
        }
        if (this.notMagicDamage(attacker, attackEntity)) {
            amount *= 0.25f;
        }
        if (!this.isLeader((LivingEntity)this)) {
            amount = this.getBossDamageAmount(this.m_9236_(), this.defTime, src, amount, 12.0f);
            this.defTime = 1;
        }
        return super.m_6469_(src, amount);
    }

    public void m_8107_() {
        super.m_8107_();
        int attackTick = this.getAttackTick();
        if (attackTick > 0) {
            this.setAttackTick(attackTick - 1);
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return;
        }
        this.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
        if (this.recastTime-- > 0) {
            return;
        }
        this.setAttackTick(10);
        this.recastTime = this.rand.nextInt(40) + 40;
        for (int i = 0; i < 5; ++i) {
            ElectricSphere entity = new ElectricSphere(this.m_9236_(), (LivingEntity)this);
            double d0 = target.m_20185_() - this.m_20185_();
            double d1 = target.m_20189_() - this.m_20189_();
            double d3 = target.m_20227_(0.3333333333333333) - this.m_20186_() - 1.0;
            Vector3f vec = this.getShotVector((Mob)this, new Vec3(d0, d3, d1), -30 + i * 15);
            entity.m_6686_(vec.m_122239_(), vec.m_122260_(), vec.m_122269_(), 1.0f, 1.0f);
            entity.setAddDamage(entity.getAddDamage() + 8.0f);
            entity.setHitDead(false);
            entity.setNotDamage(true);
            entity.setRange(3.0);
            entity.setCount(2);
            this.addEntity((Entity)entity);
        }
        this.m_5496_(SoundEvents.f_11705_, 0.5f, 0.67f);
    }

    @Override
    public boolean isLowRank() {
        return false;
    }

    @Override
    public boolean getShit() {
        return false;
    }
}

